/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lang;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public final class RemoveThreadDestroyMethod
extends Recipe {
    public static final String JAVA_LANG_THREAD = "java.lang.Thread";

    public String getDisplayName() {
        return "Remove deprecated `Thread.destroy()`";
    }

    public String getDescription() {
        return "Remove deprecated invocations of `Thread.destroy()` which have no alternatives needed.";
    }

    public Set<String> getTags() {
        return Collections.singleton("JDK-8204260");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType(JAVA_LANG_THREAD, Boolean.valueOf(false)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
                if (Objects.nonNull(mi.getSelect()) && TypeUtils.isAssignableTo((String)RemoveThreadDestroyMethod.JAVA_LANG_THREAD, (JavaType)mi.getSelect().getType()) && mi.getSimpleName().equals("destroy")) {
                    return null;
                }
                return mi;
            }
        });
    }

    @NonNull
    public String toString() {
        return "RemoveThreadDestroyMethod()";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveThreadDestroyMethod)) {
            return false;
        }
        RemoveThreadDestroyMethod other = (RemoveThreadDestroyMethod)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RemoveThreadDestroyMethod;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

