/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.util;

import java.util.StringJoiner;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;

public class UseLocaleOf
extends Recipe {
    private static final MethodMatcher NEW_LOCALE = new MethodMatcher("java.util.Locale <constructor>(..)", false);

    public String getDisplayName() {
        return "Prefer `Locale.of(..)` over `new Locale(..)`";
    }

    public String getDescription() {
        return "Prefer `Locale.of(..)` over `new Locale(..)` in Java 19 or higher.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor check = Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(19), new UsesMethod(NEW_LOCALE)});
        return Preconditions.check((TreeVisitor)check, (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
                J.NewClass nc = (J.NewClass)super.visitNewClass(newClass, (Object)ctx);
                if (NEW_LOCALE.matches(nc)) {
                    StringJoiner localeOf = new StringJoiner(", ", "Locale.of(", ")");
                    nc.getArguments().forEach(a -> localeOf.add("#{any(String)}"));
                    return JavaTemplate.builder((String)localeOf.toString()).imports(new String[]{"java.util.Locale"}).build().apply(this.updateCursor((Tree)nc), nc.getCoordinates().replace(), nc.getArguments().toArray());
                }
                return nc;
            }
        });
    }
}

