/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.logging;

import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;

public class MigrateLoggerLogrbToUseResourceBundle
extends Recipe {
    private static final MethodMatcher MATCHER = new MethodMatcher("java.util.logging.Logger logrb(java.util.logging.Level, String, String, String, String, ..)");

    public String getDisplayName() {
        return "Use `Logger#logrb(.., ResourceBundle bundleName, ..)`";
    }

    public String getDescription() {
        return "Use `Logger#logrb(.., ResourceBundle bundleName, ..)` instead of the deprecated `java.util.logging.Logger#logrb(.., String bundleName, ..)` in Java 8 or higher.";
    }

    public Set<String> getTags() {
        return Collections.singleton("deprecated");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(MATCHER), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = method;
                if (MATCHER.matches(m)) {
                    m = (J.MethodInvocation)JavaTemplate.builder((String)("#{any(java.util.logging.Level)}, #{any(String)}, #{any(String)}, ResourceBundle.getBundle(#{any(String)}), #{any(String)}" + (m.getArguments().size() == 6 ? ", #{any()}" : ""))).contextSensitive().imports(new String[]{"java.util.ResourceBundle"}).build().apply(this.getCursor(), m.getCoordinates().replaceArguments(), m.getArguments().toArray());
                    this.maybeAddImport("java.util.ResourceBundle");
                }
                return super.visitMethodInvocation(m, (Object)ctx);
            }
        });
    }
}

