/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate;

import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.maven.AddPlugin;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.xml.tree.Xml;

@Incubating(since="0.2.0")
public class AddJDeprScanPlugin
extends Recipe {
    @Option(displayName="release", description="Specifies the Java SE release that provides the set of deprecated APIs for scanning.", required=false, example="11")
    private final String release;

    public String getDisplayName() {
        return "Add `JDeprScan` Maven Plug-in";
    }

    public String getDescription() {
        return "Add the `JDeprScan` Maven plugin to scan class files for uses of deprecated APIs.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    protected List<SourceFile> visit(List<SourceFile> before, ExecutionContext ctx) {
        return ListUtils.map(before, s -> {
            if ("pom.xml".equals(s.getSourcePath().toString()) && s.getMarkers().findFirst(MavenResolutionResult.class).isPresent()) {
                return (SourceFile)new AddJDeprScanPluginVisitor().visit((Tree)s, ctx);
            }
            return s;
        });
    }

    @ConstructorProperties(value={"release"})
    public AddJDeprScanPlugin(String release) {
        this.release = release;
    }

    public String getRelease() {
        return this.release;
    }

    private class AddJDeprScanPluginVisitor
    extends MavenVisitor<ExecutionContext> {
        private AddJDeprScanPluginVisitor() {
        }

        public Xml visitDocument(Xml.Document document, ExecutionContext ctx) {
            this.doAfterVisit((Recipe)new AddPlugin("org.apache.maven.plugins", "maven-jdeprscan-plugin", "3.0.0-alpha-1", String.format("<configuration>%n   <release>%s</release>%n</configuration>", StringUtils.isNullOrEmpty((String)AddJDeprScanPlugin.this.getRelease()) ? "11" : AddJDeprScanPlugin.this.getRelease()), null, null));
            return document;
        }
    }
}

