/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.template.SourceTemplate;

public class NoGuavaListsNewArrayList
extends Recipe {
    private static final MethodMatcher NEW_ARRAY_LIST = new MethodMatcher("com.google.common.collect.Lists newArrayList()");
    private static final MethodMatcher NEW_ARRAY_LIST_ITERABLE = new MethodMatcher("com.google.common.collect.Lists newArrayList(java.lang.Iterable)");
    private static final MethodMatcher NEW_ARRAY_LIST_CAPACITY = new MethodMatcher("com.google.common.collect.Lists newArrayListWithCapacity(int)");

    public String getDisplayName() {
        return "Prefer `new ArrayList<>()`";
    }

    public String getDescription() {
        return "Prefer the Java standard library over third-party usage of Guava in simple cases like this.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public Set<String> getTags() {
        return Collections.singleton("guava");
    }

    protected TreeVisitor<?, ExecutionContext> getApplicableTest() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public JavaSourceFile visitJavaSourceFile(JavaSourceFile cu, ExecutionContext ctx) {
                this.doAfterVisit((TreeVisitor)new UsesMethod(NEW_ARRAY_LIST));
                this.doAfterVisit((TreeVisitor)new UsesMethod(NEW_ARRAY_LIST_ITERABLE));
                this.doAfterVisit((TreeVisitor)new UsesMethod(NEW_ARRAY_LIST_CAPACITY));
                return cu;
            }
        };
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){
            private final JavaTemplate newArrayList = JavaTemplate.builder(() -> (this).getCursor(), (String)"new ArrayList<>()").imports(new String[]{"java.util.ArrayList"}).build();
            private final JavaTemplate newArrayListCollection = JavaTemplate.builder(() -> (this).getCursor(), (String)"new ArrayList<>(#{any(java.util.Collection)})").imports(new String[]{"java.util.ArrayList"}).build();
            private final JavaTemplate newArrayListCapacity = JavaTemplate.builder(() -> (this).getCursor(), (String)"new ArrayList<>(#{any(int)})").imports(new String[]{"java.util.ArrayList"}).build();

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (NEW_ARRAY_LIST.matches(method)) {
                    this.maybeRemoveImport("com.google.common.collect.Lists");
                    this.maybeAddImport("java.util.ArrayList");
                    return method.withTemplate((SourceTemplate)this.newArrayList, method.getCoordinates().replace(), new Object[0]);
                }
                if (NEW_ARRAY_LIST_ITERABLE.matches(method) && method.getArguments().size() == 1 && TypeUtils.isAssignableTo((String)"java.util.Collection", (JavaType)((Expression)method.getArguments().get(0)).getType())) {
                    this.maybeRemoveImport("com.google.common.collect.Lists");
                    this.maybeAddImport("java.util.ArrayList");
                    return method.withTemplate((SourceTemplate)this.newArrayListCollection, method.getCoordinates().replace(), new Object[]{method.getArguments().get(0)});
                }
                if (NEW_ARRAY_LIST_CAPACITY.matches(method)) {
                    this.maybeRemoveImport("com.google.common.collect.Lists");
                    this.maybeAddImport("java.util.ArrayList");
                    return method.withTemplate((SourceTemplate)this.newArrayListCapacity, method.getCoordinates().replace(), new Object[]{method.getArguments().get(0)});
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }
        };
    }
}

