/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.jakarta;

import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.AddDependencyVisitor;
import org.openrewrite.maven.ChangeDependencyGroupIdAndArtifactId;
import org.openrewrite.maven.ChangeManagedDependencyGroupIdAndArtifactId;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.RemoveDependency;
import org.openrewrite.maven.RemoveRedundantDependencyVersions;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.xml.tree.Xml;

public final class UpdateJaxbRuntimeToJakartaEE8
extends Recipe {
    private static final String LEGACY_JAVA_JAXB_API_GROUP = "javax.xml.bind";
    private static final String LEGACY_JAVA_JAXB_API_ARTIFACT = "jaxb-api";
    private static final String JAKARTA_API_GROUP = "jakarta.xml.bind";
    private static final String JAKARTA_API_ARTIFACT = "jakarta.xml.bind-api";
    private static final String SUN_JAXB_RUNTIME_GROUP = "com.sun.xml.bind";
    private static final String SUN_JAXB_RUNTIME_ARTIFACT = "jaxb-impl";
    private static final String GLASSFISH_JAXB_RUNTIME_GROUP = "org.glassfish.jaxb";
    private static final String GLASSFISH_JAXB_RUNTIME_ARTIFACT = "jaxb-runtime";
    @Option(displayName="JAXB run-time", description="Which implementation of the JAXB run-time that will be added to maven projects that have transitive dependencies on the JAXB API", valid={"glassfish", "sun"}, example="glassfish")
    private final String runtime;

    public String getDisplayName() {
        return "Use latest JAXB API and runtime for Jakarta EE 8";
    }

    public String getDescription() {
        return "Update maven build files to use the latest JAXB API from Jakarta EE8 and add a compatible runtime dependency to maintain compatibility with Java versions greater than Java 8. This recipe will change existing dependencies on `javax.xml.bind:jax-api` to `jakarta.xml.bind:jakarta.xml.bind-api`. The recipe will also add a JAXB run-time, in `provided` scope, to any project that has a transitive dependency on the JAXB API. **The resulting dependencies still use the `javax` namespace, despite the move to the Jakarta artifact**.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(30L);
    }

    public Set<String> getTags() {
        return new HashSet<String>(Arrays.asList("javax", "jakarta", "javaee", "jaxb", "glassfish", "java11"));
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){

            public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                this.doAfterVisit((Recipe)new RemoveDependency(UpdateJaxbRuntimeToJakartaEE8.SUN_JAXB_RUNTIME_GROUP, "jaxb-core", null));
                Xml.Document d = super.visitDocument(document, (Object)ctx);
                d = (Xml.Document)new ChangeDependencyGroupIdAndArtifactId(UpdateJaxbRuntimeToJakartaEE8.LEGACY_JAVA_JAXB_API_GROUP, UpdateJaxbRuntimeToJakartaEE8.LEGACY_JAVA_JAXB_API_ARTIFACT, UpdateJaxbRuntimeToJakartaEE8.JAKARTA_API_GROUP, UpdateJaxbRuntimeToJakartaEE8.JAKARTA_API_ARTIFACT, "2.3.2", null).getVisitor().visit((Tree)d, (Object)ctx);
                d = (Xml.Document)new ChangeManagedDependencyGroupIdAndArtifactId(UpdateJaxbRuntimeToJakartaEE8.LEGACY_JAVA_JAXB_API_GROUP, UpdateJaxbRuntimeToJakartaEE8.LEGACY_JAVA_JAXB_API_ARTIFACT, UpdateJaxbRuntimeToJakartaEE8.JAKARTA_API_GROUP, UpdateJaxbRuntimeToJakartaEE8.JAKARTA_API_ARTIFACT, "2.3.2").getVisitor().visit((Tree)d, (Object)ctx);
                if ("sun".equals(UpdateJaxbRuntimeToJakartaEE8.this.runtime)) {
                    d = (Xml.Document)new ChangeDependencyGroupIdAndArtifactId(UpdateJaxbRuntimeToJakartaEE8.GLASSFISH_JAXB_RUNTIME_GROUP, UpdateJaxbRuntimeToJakartaEE8.GLASSFISH_JAXB_RUNTIME_ARTIFACT, UpdateJaxbRuntimeToJakartaEE8.SUN_JAXB_RUNTIME_GROUP, UpdateJaxbRuntimeToJakartaEE8.SUN_JAXB_RUNTIME_ARTIFACT, "2.3.2", null).getVisitor().visit((Tree)d, (Object)ctx);
                    d = (Xml.Document)new ChangeManagedDependencyGroupIdAndArtifactId(UpdateJaxbRuntimeToJakartaEE8.GLASSFISH_JAXB_RUNTIME_GROUP, UpdateJaxbRuntimeToJakartaEE8.GLASSFISH_JAXB_RUNTIME_ARTIFACT, UpdateJaxbRuntimeToJakartaEE8.SUN_JAXB_RUNTIME_GROUP, UpdateJaxbRuntimeToJakartaEE8.SUN_JAXB_RUNTIME_ARTIFACT, "2.3.2").getVisitor().visit((Tree)d, (Object)ctx);
                } else {
                    d = (Xml.Document)new ChangeDependencyGroupIdAndArtifactId(UpdateJaxbRuntimeToJakartaEE8.SUN_JAXB_RUNTIME_GROUP, UpdateJaxbRuntimeToJakartaEE8.SUN_JAXB_RUNTIME_ARTIFACT, UpdateJaxbRuntimeToJakartaEE8.GLASSFISH_JAXB_RUNTIME_GROUP, UpdateJaxbRuntimeToJakartaEE8.GLASSFISH_JAXB_RUNTIME_ARTIFACT, "2.3.2", null).getVisitor().visit((Tree)d, (Object)ctx);
                    d = (Xml.Document)new ChangeManagedDependencyGroupIdAndArtifactId(UpdateJaxbRuntimeToJakartaEE8.SUN_JAXB_RUNTIME_GROUP, UpdateJaxbRuntimeToJakartaEE8.SUN_JAXB_RUNTIME_ARTIFACT, UpdateJaxbRuntimeToJakartaEE8.GLASSFISH_JAXB_RUNTIME_GROUP, UpdateJaxbRuntimeToJakartaEE8.GLASSFISH_JAXB_RUNTIME_ARTIFACT, "2.3.2").getVisitor().visit((Tree)d, (Object)ctx);
                }
                if (d != document) {
                    return d;
                }
                if ((d = this.maybeAddRuntimeDependency(d, ctx)) != document) {
                    this.doAfterVisit((Recipe)new RemoveRedundantDependencyVersions(UpdateJaxbRuntimeToJakartaEE8.GLASSFISH_JAXB_RUNTIME_GROUP, "*", Boolean.valueOf(true)));
                    this.doAfterVisit((Recipe)new RemoveRedundantDependencyVersions(UpdateJaxbRuntimeToJakartaEE8.SUN_JAXB_RUNTIME_GROUP, "*", Boolean.valueOf(true)));
                    this.doAfterVisit((Recipe)new RemoveRedundantDependencyVersions(UpdateJaxbRuntimeToJakartaEE8.JAKARTA_API_GROUP, "*", Boolean.valueOf(true)));
                }
                return d;
            }

            private Xml.Document maybeAddRuntimeDependency(Xml.Document d, ExecutionContext ctx) {
                Scope runtimeScope;
                MavenResolutionResult mavenModel = this.getResolutionResult();
                Scope apiScope = UpdateJaxbRuntimeToJakartaEE8.this.getTransitiveDependencyScope(mavenModel, UpdateJaxbRuntimeToJakartaEE8.JAKARTA_API_GROUP, UpdateJaxbRuntimeToJakartaEE8.JAKARTA_API_ARTIFACT);
                Scope scope = runtimeScope = "sun".equals(UpdateJaxbRuntimeToJakartaEE8.this.runtime) ? UpdateJaxbRuntimeToJakartaEE8.this.getTransitiveDependencyScope(mavenModel, UpdateJaxbRuntimeToJakartaEE8.SUN_JAXB_RUNTIME_GROUP, UpdateJaxbRuntimeToJakartaEE8.SUN_JAXB_RUNTIME_ARTIFACT) : UpdateJaxbRuntimeToJakartaEE8.this.getTransitiveDependencyScope(mavenModel, UpdateJaxbRuntimeToJakartaEE8.GLASSFISH_JAXB_RUNTIME_GROUP, UpdateJaxbRuntimeToJakartaEE8.GLASSFISH_JAXB_RUNTIME_ARTIFACT);
                if (!(apiScope == null || runtimeScope != null && apiScope.isInClasspathOf(runtimeScope))) {
                    String resolvedScope = apiScope == Scope.Test ? "test" : "provided";
                    AddDependencyVisitor addDependency = "sun".equals(UpdateJaxbRuntimeToJakartaEE8.this.runtime) ? new AddDependencyVisitor(UpdateJaxbRuntimeToJakartaEE8.SUN_JAXB_RUNTIME_GROUP, UpdateJaxbRuntimeToJakartaEE8.SUN_JAXB_RUNTIME_ARTIFACT, "2.3.2", null, resolvedScope, null, null, null, null, null) : new AddDependencyVisitor(UpdateJaxbRuntimeToJakartaEE8.GLASSFISH_JAXB_RUNTIME_GROUP, UpdateJaxbRuntimeToJakartaEE8.GLASSFISH_JAXB_RUNTIME_ARTIFACT, "2.3.2", null, resolvedScope, null, null, null, null, null);
                    return (Xml.Document)addDependency.visit((Tree)d, (Object)ctx);
                }
                return d;
            }
        };
    }

    @Nullable
    private Scope getTransitiveDependencyScope(MavenResolutionResult mavenModel, String groupId, String artifactId) {
        Scope maxScope = null;
        block0: for (Map.Entry entry : mavenModel.getDependencies().entrySet()) {
            for (ResolvedDependency dependency : (List)entry.getValue()) {
                if (!groupId.equals(dependency.getGroupId()) || !artifactId.equals(dependency.getArtifactId())) continue;
                if (!Scope.Compile.equals((Object)(maxScope = Scope.maxPrecedence(maxScope, (Scope)((Scope)entry.getKey()))))) continue block0;
                return maxScope;
            }
        }
        return maxScope;
    }

    @ConstructorProperties(value={"runtime"})
    public UpdateJaxbRuntimeToJakartaEE8(String runtime) {
        this.runtime = runtime;
    }

    public String getRuntime() {
        return this.runtime;
    }

    @NonNull
    public String toString() {
        return "UpdateJaxbRuntimeToJakartaEE8(runtime=" + this.getRuntime() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateJaxbRuntimeToJakartaEE8)) {
            return false;
        }
        UpdateJaxbRuntimeToJakartaEE8 other = (UpdateJaxbRuntimeToJakartaEE8)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$runtime = this.getRuntime();
        String other$runtime = other.getRuntime();
        return !(this$runtime == null ? other$runtime != null : !this$runtime.equals(other$runtime));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UpdateJaxbRuntimeToJakartaEE8;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $runtime = this.getRuntime();
        result = result * 59 + ($runtime == null ? 43 : $runtime.hashCode());
        return result;
    }
}

