/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.net;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AddImport;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;

public class MigrateURLDecoderDecode
extends Recipe {
    private static final MethodMatcher MATCHER = new MethodMatcher("java.net.URLDecoder decode(String)");

    public String getDisplayName() {
        return "Use `java.net.URLDecoder#decode(String, StandardCharsets.UTF_8)`";
    }

    public String getDescription() {
        return "`java.net.URLDecoder#decode(String)` is platform-dependent. It's advised to specify an encoding.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesMethod(MATCHER);
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MigrateURLDecoderDecodeVisitor();
    }

    private static class MigrateURLDecoderDecodeVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private MigrateURLDecoderDecodeVisitor() {
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation m = method;
            if (MATCHER.matches(m)) {
                m = (J.MethodInvocation)m.withTemplate(JavaTemplate.builder(() -> ((MigrateURLDecoderDecodeVisitor)this).getCursor(), (String)"#{any(String)}, StandardCharsets.UTF_8").imports(new String[]{"java.nio.charset.StandardCharsets"}).build(), m.getCoordinates().replaceArguments(), m.getArguments().toArray());
                this.doAfterVisit((TreeVisitor)new AddImport("java.nio.charset.StandardCharsets", null, false));
            }
            return super.visitMethodInvocation(m, (Object)ctx);
        }
    }
}

