/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;

public class NoGuavaSetsNewLinkedHashSet
extends Recipe {
    private static final MethodMatcher NEW_LINKED_HASH_SET = new MethodMatcher("com.google.common.collect.Sets newLinkedHashSet()");
    private static final MethodMatcher NEW_LINKED_HASH_SET_ITERABLE = new MethodMatcher("com.google.common.collect.Sets newLinkedHashSet(java.lang.Iterable)");
    private static final MethodMatcher NEW_LINKED_HASH_SET_CAPACITY = new MethodMatcher("com.google.common.collect.Sets newLinkedHashSetWithExpectedSize(int)");

    public String getDisplayName() {
        return "Use `new LinkedHashSet<>()` instead of Guava";
    }

    public String getDescription() {
        return "Prefer the Java standard library over third-party usage of Guava in simple cases like this.";
    }

    protected TreeVisitor<?, ExecutionContext> getApplicableTest() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext executionContext) {
                this.doAfterVisit((TreeVisitor)new UsesMethod(NEW_LINKED_HASH_SET));
                this.doAfterVisit((TreeVisitor)new UsesMethod(NEW_LINKED_HASH_SET_ITERABLE));
                this.doAfterVisit((TreeVisitor)new UsesMethod(NEW_LINKED_HASH_SET_CAPACITY));
                return cu;
            }
        };
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){
            private final JavaTemplate newLinkedHashSet = JavaTemplate.builder(() -> (this).getCursor(), (String)"new LinkedHashSet<>()").imports(new String[]{"java.util.LinkedHashSet"}).build();
            private final JavaTemplate newLinkedHashSetIterable = JavaTemplate.builder(() -> (this).getCursor(), (String)"new LinkedHashSet<>(#{any(java.lang.Iterable)})").imports(new String[]{"java.util.LinkedHashSet"}).build();
            private final JavaTemplate newLinkedHashSetCapacity = JavaTemplate.builder(() -> (this).getCursor(), (String)"new LinkedHashSet<>(#{any(int)})").imports(new String[]{"java.util.LinkedHashSet"}).build();

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                if (NEW_LINKED_HASH_SET.matches(method)) {
                    this.maybeRemoveImport("com.google.common.collect.Sets");
                    this.maybeAddImport("java.util.LinkedHashSet");
                    return method.withTemplate(this.newLinkedHashSet, method.getCoordinates().replace(), new Object[0]);
                }
                if (NEW_LINKED_HASH_SET_ITERABLE.matches(method)) {
                    this.maybeRemoveImport("com.google.common.collect.Sets");
                    this.maybeAddImport("java.util.LinkedHashSet");
                    return method.withTemplate(this.newLinkedHashSetIterable, method.getCoordinates().replace(), new Object[]{method.getArguments().get(0)});
                }
                if (NEW_LINKED_HASH_SET_CAPACITY.matches(method)) {
                    this.maybeRemoveImport("com.google.common.collect.Sets");
                    this.maybeAddImport("java.util.LinkedHashSet");
                    return method.withTemplate(this.newLinkedHashSetCapacity, method.getCoordinates().replace(), new Object[]{method.getArguments().get(0)});
                }
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
        };
    }
}

