/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;

public class NoGuavaSetsNewConcurrentHashSet
extends Recipe {
    private static final MethodMatcher NEW_HASH_SET = new MethodMatcher("com.google.common.collect.Sets newConcurrentHashSet()");

    public String getDisplayName() {
        return "Construct a set from a `new ConcurrentHashMap<>()` instead of Guava";
    }

    public String getDescription() {
        return "Prefer the Java standard library over third-party usage of Guava in simple cases like this.";
    }

    protected TreeVisitor<?, ExecutionContext> getApplicableTest() {
        return new UsesMethod(NEW_HASH_SET);
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){
            private final JavaTemplate newConcurrentHashSet = JavaTemplate.builder(() -> (this).getCursor(), (String)"Collections.newSetFromMap(new ConcurrentHashMap<>())").imports(new String[]{"java.util.Collections"}).imports(new String[]{"java.util.concurrent.ConcurrentHashMap"}).build();

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                if (NEW_HASH_SET.matches(method)) {
                    this.maybeRemoveImport("com.google.common.collect.Sets");
                    this.maybeAddImport("java.util.Collections");
                    this.maybeAddImport("java.util.concurrent.ConcurrentHashMap");
                    return method.withTemplate(this.newConcurrentHashSet, method.getCoordinates().replace(), new Object[0]);
                }
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
        };
    }
}

