/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;

public class NoGuavaListsNewArrayList
extends Recipe {
    private static final MethodMatcher NEW_ARRAY_LIST = new MethodMatcher("com.google.common.collect.Lists newArrayList()");

    public String getDisplayName() {
        return "Use `new ArrayList<>()` instead of Guava";
    }

    public String getDescription() {
        return "Prefer the Java standard library over third-party usage of Guava in simple cases like this.";
    }

    protected TreeVisitor<?, ExecutionContext> getApplicableTest() {
        return new UsesMethod(NEW_ARRAY_LIST);
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){
            private final JavaTemplate newArrayList = this.template("new ArrayList<>()").imports(new String[]{"java.util.ArrayList"}).build();

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                if (NEW_ARRAY_LIST.matches(method)) {
                    this.maybeRemoveImport("com.google.common.collect.Lists");
                    this.maybeAddImport("java.util.ArrayList");
                    return method.withTemplate(this.newArrayList, method.getCoordinates().replace(), new Object[0]);
                }
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
        };
    }
}

