/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging.slf4j;

import java.util.logging.Level;
import org.openrewrite.java.template.RecipeDescriptor;
import org.slf4j.Logger;

@RecipeDescriptor(name="Replace JUL `log(Level, String, Throwable)` with corresponding SLF4J method calls", description="Replace calls to `Logger.log(Level, String, Throwable)` with the corresponding SLF4J method calls.")
public class JulToSlf4jSimpleCallsWithThrowable {

    @RecipeDescriptor(name="Replace JUL `logger.log(Level.ALL, String message, Throwable e)` with SLF4J's `Logger.trace(message, e)`", description="Replace calls to `java.util.logging.Logger.log(Level.ALL, String message, Throwable e)` with `org.slf4j.Logger.trace(message, e)`.")
    public static class JulToSlf4jSupplierAll {
        void before(java.util.logging.Logger logger, String message, Throwable e) {
            logger.log(Level.ALL, message, e);
        }

        void after(Logger logger, String message, Throwable e) {
            logger.trace(message, e);
        }
    }

    @RecipeDescriptor(name="Replace JUL `logger.log(Level.SEVERE, String message, Throwable e)` with SLF4J's `Logger.error(message, e)`", description="Replace calls to `java.util.logging.Logger.log(Level.SEVERE, String message, Throwable e)` with `org.slf4j.Logger.error(message, e)`.")
    public static class JulToSlf4jSupplierSevere {
        void before(java.util.logging.Logger logger, String message, Throwable e) {
            logger.log(Level.SEVERE, message, e);
        }

        void after(Logger logger, String message, Throwable e) {
            logger.error(message, e);
        }
    }

    @RecipeDescriptor(name="Replace JUL `logger.log(Level.WARNING, String message, Throwable e)` with SLF4J's `Logger.warn(message, e)`", description="Replace calls to `java.util.logging.Logger.log(Level.WARNING, String message, Throwable e)` with `org.slf4j.Logger.warn(message, e)`.")
    public static class JulToSlf4jSupplierWarning {
        void before(java.util.logging.Logger logger, String message, Throwable e) {
            logger.log(Level.WARNING, message, e);
        }

        void after(Logger logger, String message, Throwable e) {
            logger.warn(message, e);
        }
    }

    @RecipeDescriptor(name="Replace JUL `logger.log(Level.INFO, String message, Throwable e)` with SLF4J's `Logger.info(message, e)`", description="Replace calls to `java.util.logging.Logger.log(Level.INFO, String message, Throwable e)` with `org.slf4j.Logger.info(message, e)`.")
    public static class JulToSlf4jSupplierInfo {
        void before(java.util.logging.Logger logger, String message, Throwable e) {
            logger.log(Level.INFO, message, e);
        }

        void after(Logger logger, String message, Throwable e) {
            logger.info(message, e);
        }
    }

    @RecipeDescriptor(name="Replace JUL `logger.log(Level.CONFIG, String message, Throwable e)` with SLF4J's `Logger.info(message, e)`", description="Replace calls to `java.util.logging.Logger.log(Level.CONFIG, String message, Throwable e)` with `org.slf4j.Logger.info(message, e)`.")
    public static class JulToSlf4jSupplierConfig {
        void before(java.util.logging.Logger logger, String message, Throwable e) {
            logger.log(Level.CONFIG, message, e);
        }

        void after(Logger logger, String message, Throwable e) {
            logger.info(message, e);
        }
    }

    @RecipeDescriptor(name="Replace JUL `logger.log(Level.FINE, String message, Throwable e)` with SLF4J's `Logger.debug(message, e)`", description="Replace calls to `java.util.logging.Logger.log(Level.FINE, String message, Throwable e)` with `org.slf4j.Logger.debug(message, e)`.")
    public static class JulToSlf4jSupplierFine {
        void before(java.util.logging.Logger logger, String message, Throwable e) {
            logger.log(Level.FINE, message, e);
        }

        void after(Logger logger, String message, Throwable e) {
            logger.debug(message, e);
        }
    }

    @RecipeDescriptor(name="Replace JUL `logger.log(Level.FINER, String message, Throwable e)` with SLF4J's `Logger.trace(message, e)`", description="Replace calls to `java.util.logging.Logger.log(Level.FINER, String message, Throwable e)` with `org.slf4j.Logger.trace(message, e)`.")
    public static class JulToSlf4jSupplierFiner {
        void before(java.util.logging.Logger logger, String message, Throwable e) {
            logger.log(Level.FINER, message, e);
        }

        void after(Logger logger, String message, Throwable e) {
            logger.trace(message, e);
        }
    }

    @RecipeDescriptor(name="Replace JUL `logger.log(Level.FINEST, String message, Throwable e)` with SLF4J's `Logger.trace(message, e)`", description="Replace calls to `java.util.logging.Logger.log(Level.FINEST, String message, Throwable e)` with `org.slf4j.Logger.trace(message, e)`.")
    public static class JulToSlf4jSupplierFinest {
        void before(java.util.logging.Logger logger, String message, Throwable e) {
            logger.log(Level.FINEST, message, e);
        }

        void after(Logger logger, String message, Throwable e) {
            logger.trace(message, e);
        }
    }
}

