/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging.log4j;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

@NullMarked
public class LoggingExceptionConcatenationRecipe
extends Recipe {
    public String getDisplayName() {
        return "Log exceptions as parameters rather than as string concatenations";
    }

    public String getDescription() {
        return "By using the exception as another parameter you get the whole stack trace.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
            JavaTemplate before;
            JavaTemplate after;

            public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                JavaTemplate.Matcher matcher;
                if (this.before == null) {
                    this.before = JavaTemplate.builder((String)"#{logger:any(org.apache.logging.log4j.Logger)}.error(#{s:any(java.lang.String)} + #{e:any(java.lang.Exception)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"log4j-api-2"})).build();
                }
                if ((matcher = this.before.matcher(this.getCursor())).find()) {
                    if (this.after == null) {
                        this.after = JavaTemplate.builder((String)"#{logger:any(org.apache.logging.log4j.Logger)}.error(#{s:any(java.lang.String)}, #{e:any(java.lang.Exception)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"log4j-api-2"})).build();
                    }
                    return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                }
                return super.visitMethodInvocation(elem, (Object)ctx);
            }
        };
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.logging.log4j.Logger", Boolean.valueOf(true)), new UsesMethod("org.apache.logging.log4j.Logger error(..)", true)}), (TreeVisitor)javaVisitor);
    }
}

