/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging.jul;

import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openrewrite.java.template.RecipeDescriptor;

@RecipeDescriptor(name="Replace JUL Level arguments with the corresponding method calls", description="Replace calls to `Logger.log(Level, String)` with the corresponding method calls.")
public class LoggerLevelArgumentToMethod {

    @RecipeDescriptor(name="Replace JUL `Logger.log(Level.CONFIG, Supplier<String>)` with `Logger.config(Supplier<String>)`", description="Replace calls to `java.util.logging.Logger.log(Level.CONFIG, Supplier<String>)` with `Logger.config(Supplier<String>)`.")
    public static class LogLevelConfigSupplierToMethod {
        void before(Logger logger, Supplier<String> message) {
            logger.log(Level.CONFIG, message);
        }

        void after(Logger logger, Supplier<String> message) {
            logger.config(message);
        }
    }

    @RecipeDescriptor(name="Replace JUL `Logger.log(Level.CONFIG, String)` with `Logger.config(String)`", description="Replace calls to `java.util.logging.Logger.log(Level.CONFIG, String)` with `Logger.config(String)`.")
    public static class LogLevelConfigToMethod {
        void before(Logger logger, String message) {
            logger.log(Level.CONFIG, message);
        }

        void after(Logger logger, String message) {
            logger.config(message);
        }
    }

    @RecipeDescriptor(name="Replace JUL `Logger.log(Level.SEVERE, Supplier<String>)` with `Logger.severe(Supplier<String>)`", description="Replace calls to `java.util.logging.Logger.log(Level.SEVERE, Supplier<String>)` with `Logger.severe(Supplier<String>)`.")
    public static class LogLevelSevereSupplierToMethod {
        void before(Logger logger, Supplier<String> message) {
            logger.log(Level.SEVERE, message);
        }

        void after(Logger logger, Supplier<String> message) {
            logger.severe(message);
        }
    }

    @RecipeDescriptor(name="Replace JUL `Logger.log(Level.SEVERE, String)` with `Logger.severe(String)`", description="Replace calls to `java.util.logging.Logger.log(Level.SEVERE, String)` with `Logger.severe(String)`.")
    public static class LogLevelSevereToMethod {
        void before(Logger logger, String message) {
            logger.log(Level.SEVERE, message);
        }

        void after(Logger logger, String message) {
            logger.severe(message);
        }
    }

    @RecipeDescriptor(name="Replace JUL `Logger.log(Level.WARNING, Supplier<String>)` with `Logger.warning(Supplier<String>)`", description="Replace calls to `java.util.logging.Logger.log(Level.WARNING, Supplier<String>)` with `Logger.warning(Supplier<String>)`.")
    public static class LogLevelWarningSupplierToMethod {
        void before(Logger logger, Supplier<String> message) {
            logger.log(Level.WARNING, message);
        }

        void after(Logger logger, Supplier<String> message) {
            logger.warning(message);
        }
    }

    @RecipeDescriptor(name="Replace JUL `Logger.log(Level.WARNING, String)` with `Logger.warning(String)`", description="Replace calls to `java.util.logging.Logger.log(Level.WARNING, String)` with `Logger.warning(String)`.")
    public static class LogLevelWarningToMethod {
        void before(Logger logger, String message) {
            logger.log(Level.WARNING, message);
        }

        void after(Logger logger, String message) {
            logger.warning(message);
        }
    }

    @RecipeDescriptor(name="Replace JUL `Logger.log(Level.INFO, Supplier<String>)` with `Logger.info(Supplier<String>)`", description="Replace calls to `java.util.logging.Logger.log(Level.INFO, Supplier<String>)` with `Logger.info(Supplier<String>)`.")
    public static class LogLevelInfoSupplierToMethod {
        void before(Logger logger, Supplier<String> message) {
            logger.log(Level.INFO, message);
        }

        void after(Logger logger, Supplier<String> message) {
            logger.info(message);
        }
    }

    @RecipeDescriptor(name="Replace JUL `Logger.log(Level.INFO, String)` with `Logger.info(String)`", description="Replace calls to `java.util.logging.Logger.log(Level.INFO, String)` with `Logger.info(String)`.")
    public static class LogLevelInfoToMethod {
        void before(Logger logger, String message) {
            logger.log(Level.INFO, message);
        }

        void after(Logger logger, String message) {
            logger.info(message);
        }
    }

    @RecipeDescriptor(name="Replace JUL `Logger.log(Level.FINE, Supplier<String>)` with `Logger.fine(Supplier<String>)`", description="Replace calls to `java.util.logging.Logger.log(Level.FINE, Supplier<String>)` with `Logger.fine(Supplier<String>)`.")
    public static class LogLevelFineSupplierToMethod {
        void before(Logger logger, Supplier<String> message) {
            logger.log(Level.FINE, message);
        }

        void after(Logger logger, Supplier<String> message) {
            logger.fine(message);
        }
    }

    @RecipeDescriptor(name="Replace JUL `Logger.log(Level.FINE, String)` with `Logger.fine(String)`", description="Replace calls to `java.util.logging.Logger.log(Level.FINE, String)` with `Logger.fine(String)`.")
    public static class LogLevelFineToMethod {
        void before(Logger logger, String message) {
            logger.log(Level.FINE, message);
        }

        void after(Logger logger, String message) {
            logger.fine(message);
        }
    }

    @RecipeDescriptor(name="Replace JUL `Logger.log(Level.FINER, Supplier<String>)` with `Logger.finer(Supplier<String>)`", description="Replace calls to `java.util.logging.Logger.log(Level.FINER, Supplier<String>)` with `Logger.finer(Supplier<String>)`.")
    public static class LogLevelFinerSupplierToMethod {
        void before(Logger logger, Supplier<String> message) {
            logger.log(Level.FINER, message);
        }

        void after(Logger logger, Supplier<String> message) {
            logger.finer(message);
        }
    }

    @RecipeDescriptor(name="Replace JUL `Logger.log(Level.FINER, String)` with `Logger.finer(String)`", description="Replace calls to `java.util.logging.Logger.log(Level.FINER, String)` with `Logger.finer(String)`.")
    public static class LogLevelFinerToMethod {
        void before(Logger logger, String message) {
            logger.log(Level.FINER, message);
        }

        void after(Logger logger, String message) {
            logger.finer(message);
        }
    }

    @RecipeDescriptor(name="Replace JUL `Logger.log(Level.FINEST, Supplier<String>)` with `Logger.finest(Supplier<String>)`", description="Replace calls to `java.util.logging.Logger.log(Level.FINEST, Supplier<String>)` with `Logger.finest(Supplier<String>)`.")
    public static class LogLevelFinestSupplierToMethod {
        void before(Logger logger, Supplier<String> message) {
            logger.log(Level.FINEST, message);
        }

        void after(Logger logger, Supplier<String> message) {
            logger.finest(message);
        }
    }

    @RecipeDescriptor(name="Replace JUL `Logger.log(Level.FINEST, String)` with `Logger.finest(String)`", description="Replace calls to `java.util.logging.Logger.log(Level.FINEST, String)` with `Logger.finest(String)`.")
    public static class LogLevelFinestToMethod {
        void before(Logger logger, String message) {
            logger.log(Level.FINEST, message);
        }

        void after(Logger logger, String message) {
            logger.finest(message);
        }
    }
}

