/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging.jul;

import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class LoggerLevelArgumentToMethodRecipes
extends Recipe {
    public String getDisplayName() {
        return "Replace JUL Level arguments with the corresponding method calls";
    }

    public String getDescription() {
        return "Replace calls to `Logger.log(Level, String)` with the corresponding method calls.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new LogLevelFinestToMethodRecipe(), new LogLevelFinestSupplierToMethodRecipe(), new LogLevelFinerToMethodRecipe(), new LogLevelFinerSupplierToMethodRecipe(), new LogLevelFineToMethodRecipe(), new LogLevelFineSupplierToMethodRecipe(), new LogLevelInfoToMethodRecipe(), new LogLevelInfoSupplierToMethodRecipe(), new LogLevelWarningToMethodRecipe(), new LogLevelWarningSupplierToMethodRecipe(), new LogLevelSevereToMethodRecipe(), new LogLevelSevereSupplierToMethodRecipe(), new LogLevelConfigToMethodRecipe(), new LogLevelConfigSupplierToMethodRecipe()});
    }

    @NullMarked
    public static class LogLevelFinestToMethodRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `Logger.log(Level.FINEST, String)` with `Logger.finest(String)`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.log(Level.FINEST, String)` with `Logger.finest(String)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.log(java.util.logging.Level.FINEST, #{message:any(java.lang.String)});").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.finest(#{message:any(java.lang.String)});").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.logging.Level");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.logging.Level", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger log(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LogLevelFinestSupplierToMethodRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `Logger.log(Level.FINEST, Supplier<String>)` with `Logger.finest(Supplier<String>)`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.log(Level.FINEST, Supplier<String>)` with `Logger.finest(Supplier<String>)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.log(java.util.logging.Level.FINEST, #{message:any(java.util.function.Supplier<java.lang.String>)});").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.finest(#{message:any(java.util.function.Supplier<java.lang.String>)});").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.logging.Level");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesType("java.util.logging.Level", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger log(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LogLevelFinerToMethodRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `Logger.log(Level.FINER, String)` with `Logger.finer(String)`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.log(Level.FINER, String)` with `Logger.finer(String)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.log(java.util.logging.Level.FINER, #{message:any(java.lang.String)});").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.finer(#{message:any(java.lang.String)});").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.logging.Level");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.logging.Level", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger log(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LogLevelFinerSupplierToMethodRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `Logger.log(Level.FINER, Supplier<String>)` with `Logger.finer(Supplier<String>)`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.log(Level.FINER, Supplier<String>)` with `Logger.finer(Supplier<String>)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.log(java.util.logging.Level.FINER, #{message:any(java.util.function.Supplier<java.lang.String>)});").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.finer(#{message:any(java.util.function.Supplier<java.lang.String>)});").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.logging.Level");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesType("java.util.logging.Level", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger log(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LogLevelFineToMethodRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `Logger.log(Level.FINE, String)` with `Logger.fine(String)`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.log(Level.FINE, String)` with `Logger.fine(String)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.log(java.util.logging.Level.FINE, #{message:any(java.lang.String)});").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.fine(#{message:any(java.lang.String)});").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.logging.Level");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.logging.Level", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger log(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LogLevelFineSupplierToMethodRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `Logger.log(Level.FINE, Supplier<String>)` with `Logger.fine(Supplier<String>)`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.log(Level.FINE, Supplier<String>)` with `Logger.fine(Supplier<String>)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.log(java.util.logging.Level.FINE, #{message:any(java.util.function.Supplier<java.lang.String>)});").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.fine(#{message:any(java.util.function.Supplier<java.lang.String>)});").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.logging.Level");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesType("java.util.logging.Level", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger log(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LogLevelInfoToMethodRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `Logger.log(Level.INFO, String)` with `Logger.info(String)`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.log(Level.INFO, String)` with `Logger.info(String)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.log(java.util.logging.Level.INFO, #{message:any(java.lang.String)});").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.info(#{message:any(java.lang.String)});").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.logging.Level");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.logging.Level", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger log(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LogLevelInfoSupplierToMethodRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `Logger.log(Level.INFO, Supplier<String>)` with `Logger.info(Supplier<String>)`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.log(Level.INFO, Supplier<String>)` with `Logger.info(Supplier<String>)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.log(java.util.logging.Level.INFO, #{message:any(java.util.function.Supplier<java.lang.String>)});").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.info(#{message:any(java.util.function.Supplier<java.lang.String>)});").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.logging.Level");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesType("java.util.logging.Level", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger log(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LogLevelWarningToMethodRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `Logger.log(Level.WARNING, String)` with `Logger.warning(String)`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.log(Level.WARNING, String)` with `Logger.warning(String)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.log(java.util.logging.Level.WARNING, #{message:any(java.lang.String)});").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.warning(#{message:any(java.lang.String)});").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.logging.Level");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.logging.Level", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger log(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LogLevelWarningSupplierToMethodRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `Logger.log(Level.WARNING, Supplier<String>)` with `Logger.warning(Supplier<String>)`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.log(Level.WARNING, Supplier<String>)` with `Logger.warning(Supplier<String>)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.log(java.util.logging.Level.WARNING, #{message:any(java.util.function.Supplier<java.lang.String>)});").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.warning(#{message:any(java.util.function.Supplier<java.lang.String>)});").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.logging.Level");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesType("java.util.logging.Level", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger log(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LogLevelSevereToMethodRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `Logger.log(Level.SEVERE, String)` with `Logger.severe(String)`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.log(Level.SEVERE, String)` with `Logger.severe(String)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.log(java.util.logging.Level.SEVERE, #{message:any(java.lang.String)});").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.severe(#{message:any(java.lang.String)});").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.logging.Level");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.logging.Level", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger log(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LogLevelSevereSupplierToMethodRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `Logger.log(Level.SEVERE, Supplier<String>)` with `Logger.severe(Supplier<String>)`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.log(Level.SEVERE, Supplier<String>)` with `Logger.severe(Supplier<String>)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.log(java.util.logging.Level.SEVERE, #{message:any(java.util.function.Supplier<java.lang.String>)});").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.severe(#{message:any(java.util.function.Supplier<java.lang.String>)});").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.logging.Level");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesType("java.util.logging.Level", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger log(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LogLevelConfigToMethodRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `Logger.log(Level.CONFIG, String)` with `Logger.config(String)`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.log(Level.CONFIG, String)` with `Logger.config(String)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.log(java.util.logging.Level.CONFIG, #{message:any(java.lang.String)});").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.config(#{message:any(java.lang.String)});").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.logging.Level");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.logging.Level", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger log(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LogLevelConfigSupplierToMethodRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `Logger.log(Level.CONFIG, Supplier<String>)` with `Logger.config(Supplier<String>)`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.log(Level.CONFIG, Supplier<String>)` with `Logger.config(Supplier<String>)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.log(java.util.logging.Level.CONFIG, #{message:any(java.util.function.Supplier<java.lang.String>)});").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.config(#{message:any(java.util.function.Supplier<java.lang.String>)});").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.logging.Level");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesType("java.util.logging.Level", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger log(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

