/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dependencies.search;

import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.dependencies.internal.StaticVersionComparator;
import org.openrewrite.java.dependencies.internal.VersionParser;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.marker.Markers;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.maven.search.FindMavenProject;
import org.openrewrite.maven.table.DependenciesInUse;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;

public final class FindMinimumDependencyVersion
extends ScanningRecipe<Map<GroupArtifact, ResolvedGroupArtifactVersion>> {
    private final transient DependenciesInUse dependenciesInUse = new DependenciesInUse((Recipe)this);
    @Option(displayName="Group pattern", description="Group ID glob pattern used to match dependencies.", example="com.fasterxml.jackson.module")
    private final String groupIdPattern;
    @Option(displayName="Artifact pattern", description="Artifact ID glob pattern used to match dependencies.", example="jackson-module-*")
    private final String artifactIdPattern;
    @Option(displayName="Version", description="Match only dependencies with the specified version. Node-style [version selectors](https://docs.openrewrite.org/reference/dependency-version-selectors) may be used. All versions are searched by default.", example="1.x", required=false)
    @Nullable
    private final String version;

    public String getDisplayName() {
        return "Find the oldest matching dependency version in use";
    }

    public String getDescription() {
        return "The oldest dependency version in use is the lowest dependency version in use in any source set of any subproject of a repository. It is possible that, for example, the main source set of a project uses Jackson 2.11, but a test source set uses Jackson 2.16. In this case, the oldest Jackson version in use is Java 2.11.";
    }

    public Map<GroupArtifact, ResolvedGroupArtifactVersion> getInitialValue(ExecutionContext ctx) {
        return new HashMap<GroupArtifact, ResolvedGroupArtifactVersion>();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Map<GroupArtifact, ResolvedGroupArtifactVersion> acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Nullable
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree == null) {
                    return null;
                }
                VersionParser versionParser = new VersionParser();
                Markers m = tree.getMarkers();
                m.findFirst(GradleProject.class).ifPresent(gradle -> {
                    for (GradleDependencyConfiguration conf : gradle.getConfigurations()) {
                        FindMinimumDependencyVersion.this.collectMinimumVersions(versionParser, conf.getResolved(), acc);
                    }
                });
                m.findFirst(MavenResolutionResult.class).ifPresent(maven -> {
                    for (List resolved : maven.getDependencies().values()) {
                        FindMinimumDependencyVersion.this.collectMinimumVersions(versionParser, resolved, acc);
                    }
                });
                return tree;
            }
        };
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final Map<GroupArtifact, ResolvedGroupArtifactVersion> acc) {
        VersionComparator versionComparator = this.version == null ? null : Objects.requireNonNull((VersionComparator)Semver.validate((String)this.version, null).getValue());
        StaticVersionComparator staticVersionComparator = new StaticVersionComparator();
        VersionParser versionParser = new VersionParser();
        String minimumVersion = acc.values().stream().map(ResolvedGroupArtifactVersion::getVersion).min((d1, d2) -> staticVersionComparator.compare(versionParser.transform((String)d1), versionParser.transform((String)d2))).filter(min -> versionComparator == null || versionComparator.isValid(null, min)).orElse(null);
        if (minimumVersion == null) {
            return TreeVisitor.noop();
        }
        acc.entrySet().removeIf(e -> !((ResolvedGroupArtifactVersion)e.getValue()).getVersion().equals(minimumVersion));
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new IsBuildGradle(), new FindMavenProject().getVisitor()}), (TreeVisitor)new TreeVisitor<Tree, ExecutionContext>(){

            @Nullable
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree == null) {
                    return null;
                }
                Markers m = tree.getMarkers();
                Tree t = tree;
                t = m.findFirst(GradleProject.class).map(gradle -> {
                    Tree t2 = tree;
                    for (GradleDependencyConfiguration conf : gradle.getConfigurations()) {
                        List resolved = conf.getResolved();
                        t2 = this.recordMinimumDependencyUse(ctx, gradle.getName(), conf.getName(), resolved, t2);
                    }
                    return t2;
                }).orElse(t);
                t = m.findFirst(MavenResolutionResult.class).map(maven -> {
                    Tree t2 = tree;
                    for (Map.Entry resolved : maven.getDependencies().entrySet()) {
                        t2 = this.recordMinimumDependencyUse(ctx, maven.getPom().getArtifactId(), ((Scope)resolved.getKey()).toString().toLowerCase(), (List)resolved.getValue(), t2);
                    }
                    return t2;
                }).orElse(t);
                return t;
            }

            private Tree recordMinimumDependencyUse(ExecutionContext ctx, String projectName, String scope, List<ResolvedDependency> resolved, Tree t) {
                TreeSet<String> minimums = new TreeSet<String>();
                for (ResolvedDependency dep : resolved) {
                    for (ResolvedGroupArtifactVersion min : acc.values()) {
                        if (!dep.getGav().equals((Object)min)) continue;
                        minimums.add(dep.getGav().toString());
                        FindMinimumDependencyVersion.this.dependenciesInUse.insertRow(ctx, (Object)new DependenciesInUse.Row(projectName, t.getMarkers().findFirst(JavaSourceSet.class).map(JavaSourceSet::getName).orElse("unknown"), dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), dep.getGav().getDatedSnapshotVersion(), scope, Integer.valueOf(dep.getDepth())));
                    }
                }
                if (!minimums.isEmpty()) {
                    return SearchResult.found((Tree)t, (String)String.join((CharSequence)"\n", minimums));
                }
                return t;
            }
        });
    }

    private void collectMinimumVersions(VersionParser versionParser, List<ResolvedDependency> resolved, Map<GroupArtifact, ResolvedGroupArtifactVersion> acc) {
        StaticVersionComparator versionComparator = new StaticVersionComparator();
        for (ResolvedDependency dep : resolved) {
            if (!StringUtils.matchesGlob((String)dep.getGroupId(), (String)this.groupIdPattern)) continue;
            acc.merge(new GroupArtifact(dep.getGroupId(), dep.getArtifactId()), dep.getGav(), (d1, d2) -> versionComparator.compare(versionParser.transform(d1.getVersion()), versionParser.transform(d2.getVersion())) < 0 ? d1 : d2);
        }
    }

    @ConstructorProperties(value={"groupIdPattern", "artifactIdPattern", "version"})
    public FindMinimumDependencyVersion(String groupIdPattern, String artifactIdPattern, @Nullable String version) {
        this.groupIdPattern = groupIdPattern;
        this.artifactIdPattern = artifactIdPattern;
        this.version = version;
    }

    public DependenciesInUse getDependenciesInUse() {
        return this.dependenciesInUse;
    }

    public String getGroupIdPattern() {
        return this.groupIdPattern;
    }

    public String getArtifactIdPattern() {
        return this.artifactIdPattern;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    @NonNull
    public String toString() {
        return "FindMinimumDependencyVersion(dependenciesInUse=" + this.getDependenciesInUse() + ", groupIdPattern=" + this.getGroupIdPattern() + ", artifactIdPattern=" + this.getArtifactIdPattern() + ", version=" + this.getVersion() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindMinimumDependencyVersion)) {
            return false;
        }
        FindMinimumDependencyVersion other = (FindMinimumDependencyVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$groupIdPattern = this.getGroupIdPattern();
        String other$groupIdPattern = other.getGroupIdPattern();
        if (this$groupIdPattern == null ? other$groupIdPattern != null : !this$groupIdPattern.equals(other$groupIdPattern)) {
            return false;
        }
        String this$artifactIdPattern = this.getArtifactIdPattern();
        String other$artifactIdPattern = other.getArtifactIdPattern();
        if (this$artifactIdPattern == null ? other$artifactIdPattern != null : !this$artifactIdPattern.equals(other$artifactIdPattern)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindMinimumDependencyVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupIdPattern = this.getGroupIdPattern();
        result = result * 59 + ($groupIdPattern == null ? 43 : $groupIdPattern.hashCode());
        String $artifactIdPattern = this.getArtifactIdPattern();
        result = result * 59 + ($artifactIdPattern == null ? 43 : $artifactIdPattern.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }
}

