/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dependencies.table;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;

@JsonIgnoreType
public class DuplicateClassesReport
extends DataTable<Row> {
    public DuplicateClassesReport(Recipe recipe) {
        super(recipe, "Duplicate classes report", "Lists classes that appear in multiple dependencies on the classpath");
    }

    public static final class Row {
        @Column(displayName="Project name", description="The project containing the duplicate.")
        private final String projectName;
        @Column(displayName="Source set", description="The source set containing the duplicate (e.g., main, test).")
        private final String sourceSet;
        @Column(displayName="Type name", description="The fully qualified name of the duplicate class.")
        private final String typeName;
        @Column(displayName="Dependency 1", description="The first dependency containing the class (group:artifact:version).")
        private final String dependency1;
        @Column(displayName="Dependency 2", description="The second dependency containing the class (group:artifact:version).")
        private final String dependency2;
        @Column(displayName="Additional dependencies", description="Any additional dependencies beyond the first two that also contain this class, comma-separated.")
        private final String additionalDependencies;

        @ConstructorProperties(value={"projectName", "sourceSet", "typeName", "dependency1", "dependency2", "additionalDependencies"})
        @Generated
        public Row(String projectName, String sourceSet, String typeName, String dependency1, String dependency2, String additionalDependencies) {
            this.projectName = projectName;
            this.sourceSet = sourceSet;
            this.typeName = typeName;
            this.dependency1 = dependency1;
            this.dependency2 = dependency2;
            this.additionalDependencies = additionalDependencies;
        }

        @Generated
        public String getProjectName() {
            return this.projectName;
        }

        @Generated
        public String getSourceSet() {
            return this.sourceSet;
        }

        @Generated
        public String getTypeName() {
            return this.typeName;
        }

        @Generated
        public String getDependency1() {
            return this.dependency1;
        }

        @Generated
        public String getDependency2() {
            return this.dependency2;
        }

        @Generated
        public String getAdditionalDependencies() {
            return this.additionalDependencies;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            String this$projectName = this.getProjectName();
            String other$projectName = other.getProjectName();
            if (this$projectName == null ? other$projectName != null : !this$projectName.equals(other$projectName)) {
                return false;
            }
            String this$sourceSet = this.getSourceSet();
            String other$sourceSet = other.getSourceSet();
            if (this$sourceSet == null ? other$sourceSet != null : !this$sourceSet.equals(other$sourceSet)) {
                return false;
            }
            String this$typeName = this.getTypeName();
            String other$typeName = other.getTypeName();
            if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
                return false;
            }
            String this$dependency1 = this.getDependency1();
            String other$dependency1 = other.getDependency1();
            if (this$dependency1 == null ? other$dependency1 != null : !this$dependency1.equals(other$dependency1)) {
                return false;
            }
            String this$dependency2 = this.getDependency2();
            String other$dependency2 = other.getDependency2();
            if (this$dependency2 == null ? other$dependency2 != null : !this$dependency2.equals(other$dependency2)) {
                return false;
            }
            String this$additionalDependencies = this.getAdditionalDependencies();
            String other$additionalDependencies = other.getAdditionalDependencies();
            return !(this$additionalDependencies == null ? other$additionalDependencies != null : !this$additionalDependencies.equals(other$additionalDependencies));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $projectName = this.getProjectName();
            result = result * 59 + ($projectName == null ? 43 : $projectName.hashCode());
            String $sourceSet = this.getSourceSet();
            result = result * 59 + ($sourceSet == null ? 43 : $sourceSet.hashCode());
            String $typeName = this.getTypeName();
            result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
            String $dependency1 = this.getDependency1();
            result = result * 59 + ($dependency1 == null ? 43 : $dependency1.hashCode());
            String $dependency2 = this.getDependency2();
            result = result * 59 + ($dependency2 == null ? 43 : $dependency2.hashCode());
            String $additionalDependencies = this.getAdditionalDependencies();
            result = result * 59 + ($additionalDependencies == null ? 43 : $additionalDependencies.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DuplicateClassesReport.Row(projectName=" + this.getProjectName() + ", sourceSet=" + this.getSourceSet() + ", typeName=" + this.getTypeName() + ", dependency1=" + this.getDependency1() + ", dependency2=" + this.getDependency2() + ", additionalDependencies=" + this.getAdditionalDependencies() + ")";
        }
    }
}

