/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dependencies.search;

import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.dependencies.internal.StaticVersionComparator;
import org.openrewrite.java.dependencies.internal.VersionParser;
import org.openrewrite.java.dependencies.search.FindMinimumDependencyVersion;
import org.openrewrite.marker.Markers;
import org.openrewrite.maven.table.DependenciesInUse;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;

public final class FindMinimumJUnitVersion
extends ScanningRecipe<Map<GroupArtifact, ResolvedGroupArtifactVersion>> {
    private final transient DependenciesInUse dependenciesInUse = new DependenciesInUse((Recipe)this);
    @Option(displayName="Version", description="Determine if the provided version is the minimum JUnit version. If both JUnit 4 and JUnit 5 are present, the minimum version is JUnit 4. If only one version is present, that version is the minimum version.", example="4", valid={"4", "5"}, required=false)
    private final @Nullable String minimumVersion;
    private final String displayName = "Find minimum JUnit version";
    private final String description = "A recipe to find the minimum version of JUnit dependencies. This recipe is designed to return the minimum version of JUnit in a project. It will search for JUnit 4 and JUnit 5 dependencies in the project. If both versions are found, it will return the minimum version of JUnit 4.\nIf a minimumVersion is provided, the recipe will search to see if the minimum version of JUnit used by the project is no lower than the minimumVersion.\nFor example: if the minimumVersion is 4, and the project has JUnit 4.12 and JUnit 5.7, the recipe will return JUnit 4.12. If the project has only JUnit 5.7, the recipe will return JUnit 5.7.\nAnother example: if the minimumVersion is 5, and the project has JUnit 4.12 and JUnit 5.7, the recipe will not return any results.";

    public Map<GroupArtifact, ResolvedGroupArtifactVersion> getInitialValue(ExecutionContext ctx) {
        return new HashMap<GroupArtifact, ResolvedGroupArtifactVersion>();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Map<GroupArtifact, ResolvedGroupArtifactVersion> acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree == null) {
                    return null;
                }
                VersionParser versionParser = new VersionParser();
                Markers m = tree.getMarkers();
                m.findFirst(GradleProject.class).ifPresent(gradle -> {
                    for (GradleDependencyConfiguration conf : gradle.getConfigurations()) {
                        FindMinimumJUnitVersion.this.collectionJUnit4(versionParser, conf.getResolved(), acc);
                        FindMinimumJUnitVersion.this.collectionJUnit5(versionParser, conf.getResolved(), acc);
                    }
                });
                m.findFirst(MavenResolutionResult.class).ifPresent(maven -> {
                    for (List resolved : maven.getDependencies().values()) {
                        FindMinimumJUnitVersion.this.collectionJUnit4(versionParser, resolved, acc);
                        FindMinimumJUnitVersion.this.collectionJUnit5(versionParser, resolved, acc);
                    }
                });
                return tree;
            }
        };
    }

    private boolean isResolvedGroupArtifactVersion(ResolvedGroupArtifactVersion resolvedGroupArtifactVersion, String groupName, String artifactName) {
        return resolvedGroupArtifactVersion.getArtifactId().equals(artifactName) && resolvedGroupArtifactVersion.getGroupId().equals(groupName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TreeVisitor<?, ExecutionContext> getVisitor(Map<GroupArtifact, ResolvedGroupArtifactVersion> acc) {
        boolean hasJUnit4 = acc.values().stream().anyMatch(resolvedGroupArtifactVersion -> this.isResolvedGroupArtifactVersion((ResolvedGroupArtifactVersion)resolvedGroupArtifactVersion, "junit", "junit"));
        boolean hasJUnit5 = acc.values().stream().anyMatch(resolvedGroupArtifactVersion -> this.isResolvedGroupArtifactVersion((ResolvedGroupArtifactVersion)resolvedGroupArtifactVersion, "org.junit.jupiter", "junit-jupiter-api"));
        if (Objects.equals(this.minimumVersion, "4")) {
            if (!hasJUnit4) return TreeVisitor.noop();
            acc.entrySet().removeIf(e -> !this.isResolvedGroupArtifactVersion((ResolvedGroupArtifactVersion)e.getValue(), "junit", "junit"));
            return FindMinimumDependencyVersion.applyMarkersForLocatedGavs(acc, this.dependenciesInUse);
        } else if (Objects.equals(this.minimumVersion, "5")) {
            if (hasJUnit4) {
                return TreeVisitor.noop();
            }
            acc.entrySet().removeIf(e -> !this.isResolvedGroupArtifactVersion((ResolvedGroupArtifactVersion)e.getValue(), "org.junit.jupiter", "junit-jupiter-api"));
            return FindMinimumDependencyVersion.applyMarkersForLocatedGavs(acc, this.dependenciesInUse);
        } else {
            if (!hasJUnit4 || !hasJUnit5) return FindMinimumDependencyVersion.applyMarkersForLocatedGavs(acc, this.dependenciesInUse);
            acc.entrySet().removeIf(e -> !this.isResolvedGroupArtifactVersion((ResolvedGroupArtifactVersion)e.getValue(), "junit", "junit"));
        }
        return FindMinimumDependencyVersion.applyMarkersForLocatedGavs(acc, this.dependenciesInUse);
    }

    private void collectionJUnit4(VersionParser versionParser, List<ResolvedDependency> resolved, Map<GroupArtifact, ResolvedGroupArtifactVersion> acc) {
        FindMinimumJUnitVersion.collectVersion(versionParser, resolved, "junit", "junit", acc);
    }

    private void collectionJUnit5(VersionParser versionParser, List<ResolvedDependency> resolved, Map<GroupArtifact, ResolvedGroupArtifactVersion> acc) {
        FindMinimumJUnitVersion.collectVersion(versionParser, resolved, "org.junit.jupiter", "junit-jupiter-api", acc);
    }

    private static void collectVersion(VersionParser versionParser, List<ResolvedDependency> resolved, String groupIdPattern, String artifactIdPattern, Map<GroupArtifact, ResolvedGroupArtifactVersion> acc) {
        StaticVersionComparator versionComparator = new StaticVersionComparator();
        for (ResolvedDependency dep : resolved) {
            if (!StringUtils.matchesGlob((String)dep.getGroupId(), (String)groupIdPattern) || !StringUtils.matchesGlob((String)dep.getArtifactId(), (String)artifactIdPattern)) continue;
            acc.merge(new GroupArtifact(dep.getGroupId(), dep.getArtifactId()), dep.getGav(), (d1, d2) -> versionComparator.compare(versionParser.transform(d1.getVersion()), versionParser.transform(d2.getVersion())) < 0 ? d1 : d2);
        }
    }

    @ConstructorProperties(value={"minimumVersion"})
    @Generated
    public FindMinimumJUnitVersion(@Nullable String minimumVersion) {
        this.minimumVersion = minimumVersion;
    }

    @Generated
    public DependenciesInUse getDependenciesInUse() {
        return this.dependenciesInUse;
    }

    @Generated
    public @Nullable String getMinimumVersion() {
        return this.minimumVersion;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String toString() {
        return "FindMinimumJUnitVersion(dependenciesInUse=" + this.getDependenciesInUse() + ", minimumVersion=" + this.getMinimumVersion() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindMinimumJUnitVersion)) {
            return false;
        }
        FindMinimumJUnitVersion other = (FindMinimumJUnitVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$minimumVersion = this.getMinimumVersion();
        String other$minimumVersion = other.getMinimumVersion();
        if (this$minimumVersion == null ? other$minimumVersion != null : !this$minimumVersion.equals(other$minimumVersion)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FindMinimumJUnitVersion;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $minimumVersion = this.getMinimumVersion();
        result = result * 59 + ($minimumVersion == null ? 43 : $minimumVersion.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

