/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dependencies.search;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.dependencies.table.DuplicateClassesReport;
import org.openrewrite.java.marker.JavaProject;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public final class FindDuplicateClasses
extends ScanningRecipe<Accumulator> {
    private final transient DuplicateClassesReport report = new DuplicateClassesReport((Recipe)this);
    private final String displayName = "Find duplicate classes on the classpath";
    private final String description = "Detects classes that appear in multiple dependencies on the classpath. This is similar to what the Maven duplicate-finder-maven-plugin does. Duplicate classes can cause runtime issues when different versions of the same class are loaded.";

    public Accumulator getInitialValue(ExecutionContext ctx) {
        return new Accumulator();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Accumulator acc) {
        return new JavaVisitor<ExecutionContext>(){

            public J visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
                Optional maybeSourceSet = cu.getMarkers().findFirst(JavaSourceSet.class);
                if (!maybeSourceSet.isPresent()) {
                    return cu;
                }
                JavaSourceSet sourceSet = (JavaSourceSet)maybeSourceSet.get();
                String projectName = cu.getMarkers().findFirst(JavaProject.class).map(JavaProject::getProjectName).orElse("<unknown>");
                ProjectSourceSet pss = new ProjectSourceSet(projectName, sourceSet.getName());
                if (!acc.seen.add(pss)) {
                    return cu;
                }
                Map gavToTypes = sourceSet.getGavToTypes();
                if (gavToTypes == null || gavToTypes.isEmpty()) {
                    return cu;
                }
                HashMap<String, List> typeToGavs = new HashMap<String, List>();
                for (Map.Entry entry : gavToTypes.entrySet()) {
                    String gav = (String)entry.getKey();
                    for (JavaType.FullyQualified type : (List)entry.getValue()) {
                        typeToGavs.computeIfAbsent(type.getFullyQualifiedName(), k -> new ArrayList()).add(gav);
                    }
                }
                for (Map.Entry entry : typeToGavs.entrySet()) {
                    String typeName;
                    List gavs = (List)entry.getValue();
                    if (gavs.size() <= 1 || (typeName = (String)entry.getKey()).contains("module-info") || typeName.endsWith("package-info")) continue;
                    String additionalDeps = gavs.size() > 2 ? gavs.subList(2, gavs.size()).stream().collect(Collectors.joining(", ")) : "";
                    FindDuplicateClasses.this.report.insertRow(ctx, new DuplicateClassesReport.Row(projectName, sourceSet.getName(), typeName, (String)gavs.get(0), (String)gavs.get(1), additionalDeps));
                }
                return cu;
            }
        };
    }

    public Collection<? extends SourceFile> generate(Accumulator acc, ExecutionContext ctx) {
        return Collections.emptyList();
    }

    @Generated
    public FindDuplicateClasses() {
    }

    @Generated
    public DuplicateClassesReport getReport() {
        return this.report;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String toString() {
        return "FindDuplicateClasses(report=" + (Object)((Object)this.getReport()) + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindDuplicateClasses)) {
            return false;
        }
        FindDuplicateClasses other = (FindDuplicateClasses)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FindDuplicateClasses;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    public static class Accumulator {
        Set<ProjectSourceSet> seen = new HashSet<ProjectSourceSet>();
    }

    private static final class ProjectSourceSet {
        private final String projectName;
        private final String sourceSetName;

        @ConstructorProperties(value={"projectName", "sourceSetName"})
        @Generated
        public ProjectSourceSet(String projectName, String sourceSetName) {
            this.projectName = projectName;
            this.sourceSetName = sourceSetName;
        }

        @Generated
        public String getProjectName() {
            return this.projectName;
        }

        @Generated
        public String getSourceSetName() {
            return this.sourceSetName;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProjectSourceSet)) {
                return false;
            }
            ProjectSourceSet other = (ProjectSourceSet)o;
            String this$projectName = this.getProjectName();
            String other$projectName = other.getProjectName();
            if (this$projectName == null ? other$projectName != null : !this$projectName.equals(other$projectName)) {
                return false;
            }
            String this$sourceSetName = this.getSourceSetName();
            String other$sourceSetName = other.getSourceSetName();
            return !(this$sourceSetName == null ? other$sourceSetName != null : !this$sourceSetName.equals(other$sourceSetName));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $projectName = this.getProjectName();
            result = result * 59 + ($projectName == null ? 43 : $projectName.hashCode());
            String $sourceSetName = this.getSourceSetName();
            result = result * 59 + ($sourceSetName == null ? 43 : $sourceSetName.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FindDuplicateClasses.ProjectSourceSet(projectName=" + this.getProjectName() + ", sourceSetName=" + this.getSourceSetName() + ")";
        }
    }
}

