/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dependencies.search;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;

public final class DoesNotIncludeDependency
extends Recipe {
    private final String displayName = "Does not include dependency for Gradle and Maven";
    private final String description = "A precondition which returns false if visiting a Gradle file / Maven pom which includes the specified dependency in the classpath of some Gradle configuration / Maven scope. For compatibility with multimodule projects, this should most often be applied as a precondition.";
    @Option(displayName="Group", description="The first part of a dependency coordinate `com.google.guava:guava:VERSION`. Supports glob.", example="com.google.guava")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate `com.google.guava:guava:VERSION`. Supports glob.", example="guava")
    private final String artifactId;
    @Option(displayName="Version", description="Match only dependencies with the specified resolved version. Node-style [version selectors](https://docs.openrewrite.org/reference/dependency-version-selectors) may be used. All versions are searched by default.", example="1.x", required=false)
    private final @Nullable String version;
    @Option(displayName="Only direct dependencies", description="Default false. If enabled, transitive dependencies will not be considered.", required=false, example="true")
    private final @Nullable Boolean onlyDirect;
    @Option(displayName="Maven scope", description="Default any. If specified, only the requested scope's classpaths will be checked.", required=false, valid={"compile", "test", "runtime", "provided"}, example="compile")
    private final @Nullable String scope;
    @Option(displayName="Gradle configuration", description="Match dependencies with the specified configuration. If not specified, all configurations will be searched.", example="compileClasspath", required=false)
    private final @Nullable String configuration;

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){
            final TreeVisitor<?, ExecutionContext> gdnid;
            final TreeVisitor<?, ExecutionContext> mdnid;
            {
                this.gdnid = new org.openrewrite.gradle.search.DoesNotIncludeDependency(DoesNotIncludeDependency.this.groupId, DoesNotIncludeDependency.this.artifactId, DoesNotIncludeDependency.this.version, DoesNotIncludeDependency.this.configuration).getVisitor();
                this.mdnid = new org.openrewrite.maven.search.DoesNotIncludeDependency(DoesNotIncludeDependency.this.groupId, DoesNotIncludeDependency.this.artifactId, DoesNotIncludeDependency.this.version, DoesNotIncludeDependency.this.onlyDirect, DoesNotIncludeDependency.this.scope).getVisitor();
            }

            public boolean isAcceptable(SourceFile sourceFile, ExecutionContext ctx) {
                return this.gdnid.isAcceptable(sourceFile, (Object)ctx) || this.mdnid.isAcceptable(sourceFile, (Object)ctx);
            }

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (!(tree instanceof SourceFile)) {
                    return tree;
                }
                SourceFile s = (SourceFile)tree;
                if (this.gdnid.isAcceptable(s, (Object)ctx)) {
                    s = (SourceFile)this.gdnid.visitNonNull((Tree)s, (Object)ctx);
                } else if (this.mdnid.isAcceptable(s, (Object)ctx)) {
                    s = (SourceFile)this.mdnid.visitNonNull((Tree)s, (Object)ctx);
                }
                return s;
            }
        };
    }

    @ConstructorProperties(value={"groupId", "artifactId", "version", "onlyDirect", "scope", "configuration"})
    @Generated
    public DoesNotIncludeDependency(String groupId, String artifactId, @Nullable String version, @Nullable Boolean onlyDirect, @Nullable String scope, @Nullable String configuration) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.onlyDirect = onlyDirect;
        this.scope = scope;
        this.configuration = configuration;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Generated
    public @Nullable String getVersion() {
        return this.version;
    }

    @Generated
    public @Nullable Boolean getOnlyDirect() {
        return this.onlyDirect;
    }

    @Generated
    public @Nullable String getScope() {
        return this.scope;
    }

    @Generated
    public @Nullable String getConfiguration() {
        return this.configuration;
    }

    @Generated
    public String toString() {
        return "DoesNotIncludeDependency(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ", groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ", onlyDirect=" + this.getOnlyDirect() + ", scope=" + this.getScope() + ", configuration=" + this.getConfiguration() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DoesNotIncludeDependency)) {
            return false;
        }
        DoesNotIncludeDependency other = (DoesNotIncludeDependency)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$onlyDirect = this.getOnlyDirect();
        Boolean other$onlyDirect = other.getOnlyDirect();
        if (this$onlyDirect == null ? other$onlyDirect != null : !((Object)this$onlyDirect).equals(other$onlyDirect)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        String this$configuration = this.getConfiguration();
        String other$configuration = other.getConfiguration();
        return !(this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DoesNotIncludeDependency;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $onlyDirect = this.getOnlyDirect();
        result = result * 59 + ($onlyDirect == null ? 43 : ((Object)$onlyDirect).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        String $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        return result;
    }
}

