/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dependencies;

import java.beans.ConstructorProperties;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.dependencies.table.GradleDependencyConfigurationErrors;
import org.openrewrite.java.dependencies.table.RepositoryAccessibilityReport;
import org.openrewrite.marker.Markup;
import org.openrewrite.maven.MavenExecutionContextView;
import org.openrewrite.maven.MavenSettings;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.maven.tree.MavenRepositoryMirror;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.ResolutionEventListener;

public final class DependencyResolutionDiagnostic
extends ScanningRecipe<Accumulator> {
    private final transient RepositoryAccessibilityReport report = new RepositoryAccessibilityReport((Recipe)this);
    private final transient GradleDependencyConfigurationErrors gradleErrors = new GradleDependencyConfigurationErrors((Recipe)this);
    @Option(displayName="Group ID", description="The group ID of a dependency to attempt to download from the repository. Default value is \"com.fasterxml.jackson.core\". If this dependency is not found in the repository the error will be noted in the report. There is no need to specify an alternate value for this parameter unless the repository is known not to contain jackson-core.", example="com.fasterxml.jackson.core", required=false)
    @Nullable
    private final String groupId;
    @Option(displayName="Artifact ID", description="The artifact ID of a dependency to attempt to download from the repository. Default value is \"jackson-core\". If this dependency is not found in the repository the error will be noted in the report. There is no need to specify an alternate value for this parameter unless the repository is known not to contain jackson-core.", example="jackson-core", required=false)
    @Nullable
    private final String artifactId;
    @Option(displayName="Version", description="The version of a dependency to attempt to download from the repository. Default value is \"2.16.0\". If this dependency is not found in the repository the error will be noted in the report. There is no need to specify an alternate value for this parameter unless the repository is known not to contain jackson-core.", example="2.16.0", required=false)
    @Nullable
    private final String version;

    public String getDisplayName() {
        return "Dependency resolution diagnostic";
    }

    public String getDescription() {
        return "Recipes which manipulate dependencies must be able to successfully access the artifact repositories and resolve dependencies from them. This recipe produces two data tables used to understand the state of dependency resolution. \n\nThe Repository accessibility report lists all the artifact repositories known to the project and whether respond to network access. The network access is attempted while the recipe is run and so is representative of current conditions. \n\nThe Gradle dependency configuration errors lists all the dependency configurations that failed to resolve one or more dependencies when the project was parsed. This is representative of conditions at the time the LST was parsed.";
    }

    public Accumulator getInitialValue(ExecutionContext ctx) {
        return new Accumulator();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Accumulator acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Nullable
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (!(tree instanceof SourceFile)) {
                    return null;
                }
                tree.getMarkers().findFirst(GradleProject.class).ifPresent(gp -> {
                    acc2.foundGradle = true;
                    acc2.repositoriesFromGradle.addAll(gp.getMavenRepositories());
                    acc2.repositoriesFromGradle.addAll(gp.getMavenPluginRepositories());
                });
                tree.getMarkers().findFirst(MavenResolutionResult.class).ifPresent(mrr -> {
                    acc2.foundMaven = true;
                    acc2.repositoriesFromMaven.addAll(mrr.getPom().getRepositories());
                });
                return tree;
            }
        };
    }

    public Collection<? extends SourceFile> generate(Accumulator acc, ExecutionContext ctx) {
        HashSet<String> seen = new HashSet<String>();
        if (acc.foundMaven) {
            this.record(true, acc.repositoriesFromMaven, seen, ctx);
        }
        if (acc.foundGradle) {
            this.record(false, acc.repositoriesFromGradle, seen, ctx);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void record(boolean addMavenDefaultRepositories, Collection<MavenRepository> repos, Set<String> seen, ExecutionContext ctx) {
        MavenPomDownloader mpd = new MavenPomDownloader(ctx);
        Collection<MavenRepository> effectiveRepos = repos;
        if (addMavenDefaultRepositories) {
            if (!effectiveRepos.contains(MavenRepository.MAVEN_LOCAL_DEFAULT)) {
                effectiveRepos = new ArrayList<MavenRepository>(effectiveRepos);
                effectiveRepos.add(MavenRepository.MAVEN_LOCAL_DEFAULT);
            }
            if (!effectiveRepos.contains(MavenRepository.MAVEN_CENTRAL)) {
                effectiveRepos = new ArrayList<MavenRepository>(effectiveRepos);
                effectiveRepos.add(MavenRepository.MAVEN_CENTRAL);
            }
        }
        MavenExecutionContextView mctx = MavenExecutionContextView.view((ExecutionContext)ctx);
        ResolutionEventListener resolutionListener = mctx.getResolutionListener();
        try {
            for (MavenRepository repo : effectiveRepos) {
                if (seen.contains(DependencyResolutionDiagnostic.noTrailingSlash(repo.getUri()))) continue;
                final AtomicReference nullReason = new AtomicReference();
                mctx.setResolutionListener(new ResolutionEventListener(){

                    public void repositoryAccessFailed(String uri, Throwable e) {
                        nullReason.set(e);
                    }
                });
                MavenRepository normalized = mpd.normalizeRepository(repo, mctx, null);
                if (normalized == null) {
                    MavenSettings settings;
                    Throwable reason = (Throwable)nullReason.get();
                    if (reason == null) {
                        reason = new RuntimeException("Repository unreachable for unknown reason");
                    }
                    if ((settings = mctx.getSettings()) != null) {
                        repo = MavenRepositoryMirror.apply((Collection)mctx.getMirrors(settings), (MavenRepository)repo);
                    }
                    if (!seen.add(DependencyResolutionDiagnostic.noTrailingSlash(repo.getUri()))) continue;
                    this.report.insertRow(ctx, DependencyResolutionDiagnostic.rowFor(repo, reason, null));
                    continue;
                }
                if (!seen.add(DependencyResolutionDiagnostic.noTrailingSlash(normalized.getUri()))) continue;
                GroupArtifactVersion gav = new GroupArtifactVersion(StringUtils.isBlank((String)this.groupId) ? "com.fasterxml.jackson.core" : this.groupId, StringUtils.isBlank((String)this.artifactId) ? "jackson-core" : this.artifactId, StringUtils.isBlank((String)this.version) ? "2.16.0" : this.version);
                Exception resolutionThrowable = null;
                try {
                    mpd.download(gav, null, null, Collections.singletonList(normalized));
                }
                catch (Exception e) {
                    resolutionThrowable = e;
                }
                this.report.insertRow(ctx, DependencyResolutionDiagnostic.rowFor(normalized, null, resolutionThrowable));
            }
        }
        finally {
            mctx.setResolutionListener(resolutionListener);
        }
    }

    private static String noTrailingSlash(String uri) {
        if (uri.endsWith("/")) {
            return uri.substring(0, uri.length() - 1);
        }
        return uri;
    }

    private static RepositoryAccessibilityReport.Row rowFor(MavenRepository repo, @Nullable Throwable pingThrowable, @Nullable Throwable resolveThrowable) {
        Integer pingHttpResponseCode = null;
        String pingExceptionClass = "";
        String pingExceptionMessage = "";
        if (pingThrowable instanceof MavenPomDownloader.HttpSenderResponseException) {
            pingHttpResponseCode = ((MavenPomDownloader.HttpSenderResponseException)pingThrowable).getResponseCode();
            pingThrowable = pingThrowable.getCause();
        }
        if (pingThrowable instanceof UncheckedIOException) {
            pingThrowable = pingThrowable.getCause();
        }
        if (pingThrowable == null) {
            pingHttpResponseCode = 200;
        } else {
            pingExceptionClass = pingThrowable.getClass().getName();
            pingExceptionMessage = pingThrowable.getMessage();
        }
        String resolveExceptionClass = "";
        String resolveExceptionMessage = "";
        if (resolveThrowable instanceof MavenPomDownloader.HttpSenderResponseException) {
            resolveThrowable = resolveThrowable.getCause();
        }
        if (resolveThrowable instanceof UncheckedIOException) {
            resolveThrowable = resolveThrowable.getCause();
        }
        if (resolveThrowable != null) {
            resolveExceptionClass = resolveThrowable.getClass().getName();
            resolveExceptionMessage = resolveThrowable.getMessage();
        }
        return new RepositoryAccessibilityReport.Row(DependencyResolutionDiagnostic.noTrailingSlash(repo.getUri()), pingExceptionClass, pingExceptionMessage, pingHttpResponseCode, resolveExceptionClass, resolveExceptionMessage);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(Accumulator acc) {
        GroovyIsoVisitor<ExecutionContext> gv = new GroovyIsoVisitor<ExecutionContext>(){

            public G.CompilationUnit visitCompilationUnit(G.CompilationUnit cu, ExecutionContext ctx) {
                Optional maybeGp = cu.getMarkers().findFirst(GradleProject.class);
                if (!maybeGp.isPresent()) {
                    return cu;
                }
                GradleProject gp = (GradleProject)maybeGp.get();
                G.CompilationUnit g = super.visitCompilationUnit(cu, (Object)ctx);
                for (GradleDependencyConfiguration conf : gp.getConfigurations()) {
                    if (conf.getExceptionType() == null) continue;
                    DependencyResolutionDiagnostic.this.gradleErrors.insertRow(ctx, new GradleDependencyConfigurationErrors.Row(gp.getPath(), conf.getName(), conf.getExceptionType(), conf.getMessage()));
                }
                return g;
            }
        };
        return new TreeVisitor<Tree, ExecutionContext>((GroovyIsoVisitor)gv){
            final /* synthetic */ GroovyIsoVisitor val$gv;
            {
                this.val$gv = groovyIsoVisitor;
            }

            @Nullable
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (!(tree instanceof SourceFile)) {
                    return tree;
                }
                SourceFile s = (SourceFile)tree;
                if (s.getSourcePath().endsWith("build.gradle") && !s.getMarkers().findFirst(GradleProject.class).isPresent()) {
                    s = s.getMarkers().getMarkers().stream().anyMatch(marker -> "org.openrewrite.gradle.marker.GradleProject".equals(marker.getClass().getName())) ? (SourceFile)Markup.error((Tree)s, (Throwable)new IllegalStateException(s.getSourcePath() + " has a GradleProject marker, but it is loaded by a different classloader than the recipe.")) : (SourceFile)Markup.warn((Tree)s, (Throwable)new IllegalStateException(s.getSourcePath() + " is a Gradle build file, but it is missing a GradleProject marker."));
                } else if (s.getSourcePath().endsWith("pom.xml") && !s.getMarkers().findFirst(MavenResolutionResult.class).isPresent()) {
                    s = s.getMarkers().getMarkers().stream().anyMatch(marker -> "org.openrewrite.maven.tree.MavenResolutionResult".equals(marker.getClass().getName())) ? (SourceFile)Markup.error((Tree)s, (Throwable)new IllegalStateException(s.getSourcePath() + " has a MavenResolutionResult marker, but it is loaded by a different classloader than the recipe.")) : (SourceFile)Markup.warn((Tree)s, (Throwable)new IllegalStateException(s.getSourcePath() + " is a Maven pom, but it is missing a MavenResolutionResult marker."));
                }
                if (this.val$gv.isAcceptable(s, (Object)ctx)) {
                    s = (SourceFile)this.val$gv.visit((Tree)s, (Object)ctx);
                }
                return s;
            }
        };
    }

    @ConstructorProperties(value={"groupId", "artifactId", "version"})
    @Generated
    public DependencyResolutionDiagnostic(@Nullable String groupId, @Nullable String artifactId, @Nullable String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    @Generated
    public RepositoryAccessibilityReport getReport() {
        return this.report;
    }

    @Generated
    public GradleDependencyConfigurationErrors getGradleErrors() {
        return this.gradleErrors;
    }

    @Nullable
    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Nullable
    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Nullable
    @Generated
    public String getVersion() {
        return this.version;
    }

    @NonNull
    @Generated
    public String toString() {
        return "DependencyResolutionDiagnostic(report=" + (Object)((Object)this.getReport()) + ", gradleErrors=" + (Object)((Object)this.getGradleErrors()) + ", groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DependencyResolutionDiagnostic)) {
            return false;
        }
        DependencyResolutionDiagnostic other = (DependencyResolutionDiagnostic)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof DependencyResolutionDiagnostic;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }

    public static class Accumulator {
        boolean foundGradle;
        Set<MavenRepository> repositoriesFromGradle = new HashSet<MavenRepository>();
        boolean foundMaven;
        Set<MavenRepository> repositoriesFromMaven = new HashSet<MavenRepository>();
    }
}

