/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github.security;

import java.util.regex.Pattern;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.github.IsGitHubActionsWorkflow;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class UnpinnedActionsRecipe
extends Recipe {
    private static final Pattern UNPINNED_ACTION_PATTERN = Pattern.compile("^([^/@]+/[^/@]+)(@(main|master|HEAD|latest|v?\\d+(\\.\\d+)*(\\.\\d+)*))??$");
    private static final Pattern SHA_PATTERN = Pattern.compile("^[a-f0-9]{40}$");
    private final String displayName = "Pin GitHub Actions to specific commits";
    private final String description = "Pin GitHub Actions to specific commit SHAs for security and reproducibility. Actions pinned to tags or branches can be changed by the action author, while SHA pins are immutable. Based on [zizmor's unpinned-uses audit](https://github.com/woodruffw/zizmor/blob/main/crates/zizmor/src/audit/unpinned_uses.rs).";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new IsGitHubActionsWorkflow(), (TreeVisitor)new UnpinnedActionsVisitor());
    }

    @Generated
    public UnpinnedActionsRecipe() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String toString() {
        return "UnpinnedActionsRecipe(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnpinnedActionsRecipe)) {
            return false;
        }
        UnpinnedActionsRecipe other = (UnpinnedActionsRecipe)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UnpinnedActionsRecipe;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    private static class UnpinnedActionsVisitor
    extends YamlIsoVisitor<ExecutionContext> {
        private UnpinnedActionsVisitor() {
        }

        public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
            String usesValue;
            Yaml.Mapping.Entry mappingEntry = super.visitMappingEntry(entry, (Object)ctx);
            if (this.isUsesEntry(mappingEntry) && (usesValue = this.getUsesValue(mappingEntry)) != null && this.isUnpinned(usesValue)) {
                return (Yaml.Mapping.Entry)SearchResult.found((Tree)mappingEntry, (String)("Action '" + usesValue + "' is not pinned to a commit SHA. Consider pinning to a specific commit for security and reproducibility."));
            }
            return mappingEntry;
        }

        private boolean isUsesEntry(Yaml.Mapping.Entry entry) {
            return entry.getKey() instanceof Yaml.Scalar && "uses".equals(((Yaml.Scalar)entry.getKey()).getValue());
        }

        private String getUsesValue(Yaml.Mapping.Entry entry) {
            if (entry.getValue() instanceof Yaml.Scalar) {
                return ((Yaml.Scalar)entry.getValue()).getValue();
            }
            return null;
        }

        private boolean isUnpinned(String usesValue) {
            if (usesValue.startsWith("./")) {
                return false;
            }
            if (usesValue.startsWith("docker://")) {
                return false;
            }
            String[] parts = usesValue.split("@", 2);
            if (parts.length < 2) {
                return true;
            }
            String version = parts[1];
            if (SHA_PATTERN.matcher(version).matches()) {
                return false;
            }
            return UNPINNED_ACTION_PATTERN.matcher(usesValue).matches();
        }
    }
}

