/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github;

import java.util.regex.Pattern;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.github.IsGitHubActionsWorkflow;
import org.openrewrite.marker.Markers;
import org.openrewrite.yaml.JsonPathMatcher;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class PreferSecretsInheritWorkflow
extends Recipe {
    private final String displayName = "Use `secrets: inherit` if possible";
    private final String description = "Pass all secrets to a reusable workflow using `secrets: inherit`. See [Simplify using secrets with reusable workflows](https://github.blog/changelog/2022-05-03-github-actions-simplify-using-secrets-with-reusable-workflows/) for details.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final JsonPathMatcher secrets = new JsonPathMatcher("$.jobs..secrets");
        return Preconditions.check(new IsGitHubActionsWorkflow().getVisitor(), (TreeVisitor)new YamlIsoVisitor<ExecutionContext>(){
            private static final String USE_INHERIT = "USE_INHERIT";

            public Yaml.Mapping visitMapping(Yaml.Mapping mapping, ExecutionContext ctx) {
                boolean allUntransformed;
                Cursor parentEntry = this.getCursor().getParent();
                if (parentEntry != null && secrets.matches(parentEntry) && (allUntransformed = mapping.getEntries().stream().allMatch(this::isUntransformedSecret))) {
                    this.getCursor().putMessageOnFirstEnclosing(Yaml.Mapping.Entry.class, USE_INHERIT, (Object)true);
                }
                return super.visitMapping(mapping, (Object)ctx);
            }

            public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                Yaml.Mapping.Entry e = super.visitMappingEntry(entry, (Object)ctx);
                if (((Boolean)this.getCursor().getMessage(USE_INHERIT, (Object)false)).booleanValue()) {
                    Yaml.Scalar inheritValue = new Yaml.Scalar(Tree.randomId(), " ", Markers.EMPTY, Yaml.Scalar.Style.PLAIN, null, null, "inherit");
                    return e.withValue((Yaml.Block)inheritValue);
                }
                return e;
            }

            private boolean isUntransformedSecret(Yaml.Mapping.Entry entry) {
                String key = entry.getKey().getValue();
                Pattern secretPattern = Pattern.compile("\\$\\{\\{\\s*secrets." + key + "\\s*}}");
                Yaml.Block value = entry.getValue();
                return value instanceof Yaml.Scalar && secretPattern.matcher(((Yaml.Scalar)value).getValue()).matches();
            }
        });
    }

    @Generated
    public PreferSecretsInheritWorkflow() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String toString() {
        return "PreferSecretsInheritWorkflow(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PreferSecretsInheritWorkflow)) {
            return false;
        }
        PreferSecretsInheritWorkflow other = (PreferSecretsInheritWorkflow)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PreferSecretsInheritWorkflow;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

