/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github;

import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.yaml.JsonPathMatcher;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class ChangeDependabotScheduleInterval
extends Recipe {
    @Option(displayName="Package ecosystem", description="The package-ecosystem to make updates on.", example="maven")
    private final String packageEcosystem;
    @Option(displayName="Schedule interval", description="The schedule interval value the package-ecosystem should use.", valid={"daily", "weekly", "monthly"}, example="weekly")
    private final String interval;
    private final String displayName = "Change dependabot schedule interval";
    private final String description = "Change the schedule interval for a given package-ecosystem in a `dependabot.yml` configuration file. [The available configuration options for dependabot are listed on GitHub](https://docs.github.com/en/code-security/supply-chain-security/keeping-your-dependencies-updated-automatically/configuration-options-for-dependency-updates).";

    public Set<String> getTags() {
        HashSet<String> tags = new HashSet<String>();
        tags.add("dependabot");
        tags.add("dependencies");
        tags.add("github");
        return tags;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new FindSourceFiles(".github/dependabot.{yml,yaml}"), (TreeVisitor)new YamlIsoVisitor<ExecutionContext>(){
            private final JsonPathMatcher targetEcosystem;
            {
                this.targetEcosystem = new JsonPathMatcher("$.updates[?(@.package-ecosystem =~ '" + ChangeDependabotScheduleInterval.this.packageEcosystem + "')].schedule.interval");
            }

            public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                if (this.targetEcosystem.matches(this.getCursor()) && !((Yaml.Scalar)entry.getValue()).getValue().equals(ChangeDependabotScheduleInterval.this.interval)) {
                    return super.visitMappingEntry(entry.withValue((Yaml.Block)((Yaml.Scalar)entry.getValue()).withValue(ChangeDependabotScheduleInterval.this.interval)), (Object)ctx);
                }
                return super.visitMappingEntry(entry, (Object)ctx);
            }
        });
    }

    @Generated
    public ChangeDependabotScheduleInterval(String packageEcosystem, String interval) {
        this.packageEcosystem = packageEcosystem;
        this.interval = interval;
    }

    @Generated
    public String getPackageEcosystem() {
        return this.packageEcosystem;
    }

    @Generated
    public String getInterval() {
        return this.interval;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String toString() {
        return "ChangeDependabotScheduleInterval(packageEcosystem=" + this.getPackageEcosystem() + ", interval=" + this.getInterval() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeDependabotScheduleInterval)) {
            return false;
        }
        ChangeDependabotScheduleInterval other = (ChangeDependabotScheduleInterval)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$packageEcosystem = this.getPackageEcosystem();
        String other$packageEcosystem = other.getPackageEcosystem();
        if (this$packageEcosystem == null ? other$packageEcosystem != null : !this$packageEcosystem.equals(other$packageEcosystem)) {
            return false;
        }
        String this$interval = this.getInterval();
        String other$interval = other.getInterval();
        if (this$interval == null ? other$interval != null : !this$interval.equals(other$interval)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ChangeDependabotScheduleInterval;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $packageEcosystem = this.getPackageEcosystem();
        result = result * 59 + ($packageEcosystem == null ? 43 : $packageEcosystem.hashCode());
        String $interval = this.getInterval();
        result = result * 59 + ($interval == null ? 43 : $interval.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

