/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github.security;

import java.util.regex.Pattern;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.github.IsGitHubActionsWorkflow;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class HardcodedCredentialsRecipe
extends Recipe {
    private static final Pattern GITHUB_EXPRESSION_PATTERN = Pattern.compile("\\$\\{\\{.*?\\}\\}");
    private final String displayName = "Find hardcoded container credentials";
    private final String description = "Detects hardcoded credentials in GitHub Actions container configurations. Container registry passwords should use secrets instead of hardcoded values. Based on [zizmor's hardcoded-container-credentials audit](https://github.com/woodruffw/zizmor/blob/main/crates/zizmor/src/audit/hardcoded_container_credentials.rs).";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new IsGitHubActionsWorkflow(), (TreeVisitor)new HardcodedCredentialsVisitor());
    }

    @Generated
    public HardcodedCredentialsRecipe() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String toString() {
        return "HardcodedCredentialsRecipe(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HardcodedCredentialsRecipe)) {
            return false;
        }
        HardcodedCredentialsRecipe other = (HardcodedCredentialsRecipe)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HardcodedCredentialsRecipe;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    private static class HardcodedCredentialsVisitor
    extends YamlIsoVisitor<ExecutionContext> {
        private HardcodedCredentialsVisitor() {
        }

        public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
            String passwordValue;
            Yaml.Mapping.Entry mappingEntry = super.visitMappingEntry(entry, (Object)ctx);
            if (this.isPasswordEntry(mappingEntry) && (passwordValue = this.getPasswordValue(mappingEntry)) != null && this.isHardcodedPassword(passwordValue)) {
                return (Yaml.Mapping.Entry)SearchResult.found((Tree)mappingEntry, (String)("Container registry password '" + passwordValue + "' appears to be hardcoded. Use secrets (e.g., ${{ secrets.REGISTRY_PASSWORD }}) instead."));
            }
            return mappingEntry;
        }

        private boolean isPasswordEntry(Yaml.Mapping.Entry entry) {
            if (!(entry.getKey() instanceof Yaml.Scalar)) {
                return false;
            }
            String key = ((Yaml.Scalar)entry.getKey()).getValue();
            return "password".equals(key);
        }

        private String getPasswordValue(Yaml.Mapping.Entry entry) {
            if (entry.getValue() instanceof Yaml.Scalar) {
                return ((Yaml.Scalar)entry.getValue()).getValue();
            }
            return null;
        }

        private boolean isHardcodedPassword(String passwordValue) {
            return !GITHUB_EXPRESSION_PATTERN.matcher(passwordValue).find();
        }
    }
}

