/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github;

import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.github.IsGitHubActionsWorkflow;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.yaml.JsonPathMatcher;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class RemoveWorkflowInputArgument
extends Recipe {
    @Option(displayName="Workflow reference", description="The workflow reference to match (e.g., `org/repo/.github/workflows/myWorkflow.yml`).", example="org/repo/.github/workflows/myWorkflow.yml")
    private final String workflowReference;
    @Option(displayName="Version", description="The version of the workflow to match (e.g., `v1.2.3`).", example="v1.2.3")
    private final String version;
    @Option(displayName="Input argument name", description="The name of the input argument to remove.", example="myInputToRemove")
    private final String inputArgumentName;
    private final String displayName = "Remove workflow input argument";
    private final String description = "Remove a specific input argument from calls to a reusable workflow.";
    private final Duration estimatedEffortPerOccurrence = Duration.ofMinutes(5L);

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final JsonPathMatcher jobsMatcher = new JsonPathMatcher("$.jobs.*");
        final String expectedReference = this.workflowReference + "@" + this.version;
        return Preconditions.check((Recipe)new IsGitHubActionsWorkflow(), (TreeVisitor)new YamlIsoVisitor<ExecutionContext>(){

            public Yaml.Mapping visitMapping(Yaml.Mapping mapping, ExecutionContext ctx) {
                Yaml.Mapping m = super.visitMapping(mapping, (Object)ctx);
                boolean matchingWorkflow = false;
                boolean argumentIsUsed = false;
                if (jobsMatcher.matches(this.getCursor().getParent().getParent())) {
                    Yaml.Block withValue;
                    Optional<Yaml.Mapping.Entry> withEntry;
                    Yaml.Block usesValue;
                    Optional<Yaml.Mapping.Entry> usesEntry = m.getEntries().stream().filter(e -> e.getKey() instanceof Yaml.Scalar && "uses".equals(e.getKey().getValue())).findAny();
                    if (usesEntry.isPresent() && (usesValue = usesEntry.get().getValue()) instanceof Yaml.Scalar && ((Yaml.Scalar)usesValue).getValue().equals(expectedReference)) {
                        matchingWorkflow = true;
                    }
                    if ((withEntry = m.getEntries().stream().filter(e -> e.getKey() instanceof Yaml.Scalar && "with".equals(e.getKey().getValue())).findAny()).isPresent() && (withValue = withEntry.get().getValue()) instanceof Yaml.Mapping) {
                        Yaml.Mapping withMapping = (Yaml.Mapping)withValue;
                        argumentIsUsed = withMapping.getEntries().stream().anyMatch(e -> e.getKey() instanceof Yaml.Scalar && RemoveWorkflowInputArgument.this.inputArgumentName.equals(e.getKey().getValue()));
                    }
                }
                if (matchingWorkflow && argumentIsUsed) {
                    return m.withEntries(ListUtils.map((List)m.getEntries(), entry -> {
                        if (entry.getKey() instanceof Yaml.Scalar && "with".equals(entry.getKey().getValue()) && entry.getValue() instanceof Yaml.Mapping) {
                            Yaml.Mapping withMapping = (Yaml.Mapping)entry.getValue();
                            Yaml.Mapping newMapping = withMapping.withEntries(withMapping.getEntries().stream().filter(e -> !(e.getKey() instanceof Yaml.Scalar) || !RemoveWorkflowInputArgument.this.inputArgumentName.equals(e.getKey().getValue())).collect(Collectors.toList()));
                            if (newMapping.getEntries().isEmpty()) {
                                return null;
                            }
                            return entry.withValue((Yaml.Block)newMapping);
                        }
                        return entry;
                    }));
                }
                return m;
            }
        });
    }

    @Generated
    public RemoveWorkflowInputArgument(String workflowReference, String version, String inputArgumentName) {
        this.workflowReference = workflowReference;
        this.version = version;
        this.inputArgumentName = inputArgumentName;
    }

    @Generated
    public String getWorkflowReference() {
        return this.workflowReference;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getInputArgumentName() {
        return this.inputArgumentName;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Duration getEstimatedEffortPerOccurrence() {
        return this.estimatedEffortPerOccurrence;
    }

    @Generated
    public String toString() {
        return "RemoveWorkflowInputArgument(workflowReference=" + this.getWorkflowReference() + ", version=" + this.getVersion() + ", inputArgumentName=" + this.getInputArgumentName() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ", estimatedEffortPerOccurrence=" + this.getEstimatedEffortPerOccurrence() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveWorkflowInputArgument)) {
            return false;
        }
        RemoveWorkflowInputArgument other = (RemoveWorkflowInputArgument)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$workflowReference = this.getWorkflowReference();
        String other$workflowReference = other.getWorkflowReference();
        if (this$workflowReference == null ? other$workflowReference != null : !this$workflowReference.equals(other$workflowReference)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$inputArgumentName = this.getInputArgumentName();
        String other$inputArgumentName = other.getInputArgumentName();
        if (this$inputArgumentName == null ? other$inputArgumentName != null : !this$inputArgumentName.equals(other$inputArgumentName)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Duration this$estimatedEffortPerOccurrence = this.getEstimatedEffortPerOccurrence();
        Duration other$estimatedEffortPerOccurrence = other.getEstimatedEffortPerOccurrence();
        return !(this$estimatedEffortPerOccurrence == null ? other$estimatedEffortPerOccurrence != null : !((Object)this$estimatedEffortPerOccurrence).equals(other$estimatedEffortPerOccurrence));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RemoveWorkflowInputArgument;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $workflowReference = this.getWorkflowReference();
        result = result * 59 + ($workflowReference == null ? 43 : $workflowReference.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $inputArgumentName = this.getInputArgumentName();
        result = result * 59 + ($inputArgumentName == null ? 43 : $inputArgumentName.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Duration $estimatedEffortPerOccurrence = this.getEstimatedEffortPerOccurrence();
        result = result * 59 + ($estimatedEffortPerOccurrence == null ? 43 : ((Object)$estimatedEffortPerOccurrence).hashCode());
        return result;
    }
}

