/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.github.SetupJavaDistributionReplacerVisitor;

public class SetupJavaAdoptOpenj9ToSemeru
extends Recipe {
    public String getDisplayName() {
        return "Use `actions/setup-java` IBM `semeru` distribution";
    }

    public String getDescription() {
        return "Adopt OpenJDK got moved to Eclipse Temurin and won't be updated anymore. It is highly recommended to migrate workflows from adopt-openj9 to IBM semeru to keep receiving software and security updates. See more details in the [Good-bye AdoptOpenJDK post](https://blog.adoptopenjdk.net/2021/08/goodbye-adoptopenjdk-hello-adoptium/).";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public Set<String> getTags() {
        return Collections.singleton("security");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new FindSourceFiles(".github/workflows/*.yml"), (TreeVisitor)new SetupJavaDistributionReplacerVisitor(Collections.singletonList("adopt-openj9"), "semeru"));
    }
}

