/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github;

import java.util.Arrays;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.yaml.ChangeValue;

public final class ReplaceRunners
extends Recipe {
    @Option(displayName="Job Name", description="The name of the job to update", example="build")
    private final String jobName;
    @Option(displayName="Runners", description="The new list of runners to set", example="ubuntu-latest")
    private final List<String> runners;

    public String getDisplayName() {
        return "Replace runners for a job";
    }

    public String getDescription() {
        return "Replaces the runners of a given job.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new FindSourceFiles(".github/workflows/*.yml"), (TreeVisitor)new ChangeValue(String.format("$.jobs.%s.runs-on", this.jobName), Arrays.toString(this.runners.toArray())).getVisitor());
    }

    public ReplaceRunners(String jobName, List<String> runners) {
        this.jobName = jobName;
        this.runners = runners;
    }

    public String getJobName() {
        return this.jobName;
    }

    public List<String> getRunners() {
        return this.runners;
    }

    public String toString() {
        return "ReplaceRunners(jobName=" + this.getJobName() + ", runners=" + this.getRunners() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReplaceRunners)) {
            return false;
        }
        ReplaceRunners other = (ReplaceRunners)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$jobName = this.getJobName();
        String other$jobName = other.getJobName();
        if (this$jobName == null ? other$jobName != null : !this$jobName.equals(other$jobName)) {
            return false;
        }
        List<String> this$runners = this.getRunners();
        List<String> other$runners = other.getRunners();
        return !(this$runners == null ? other$runners != null : !((Object)this$runners).equals(other$runners));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReplaceRunners;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $jobName = this.getJobName();
        result = result * 59 + ($jobName == null ? 43 : $jobName.hashCode());
        List<String> $runners = this.getRunners();
        result = result * 59 + ($runners == null ? 43 : ((Object)$runners).hashCode());
        return result;
    }
}

