/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github;

import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.yaml.ChangeValue;

public final class ChangeActionVersion
extends Recipe {
    @Option(displayName="Action", description="Name of the action to update.", example="actions/setup-java")
    private final String action;
    @Option(displayName="Version", description="Version to use.", example="v4")
    private final String version;

    public String getDisplayName() {
        return "Change GitHub Action version";
    }

    public String getDescription() {
        return "Change the version of a GitHub Action in any `.github/workflows/*.yml` file.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new FindSourceFiles(".github/workflows/*.yml"), (TreeVisitor)new ChangeValue("$.jobs..steps[?(@.uses =~ '" + this.action + "(?:@.+)?')].uses", this.action + '@' + this.version).getVisitor());
    }

    public ChangeActionVersion(String action, String version) {
        this.action = action;
        this.version = version;
    }

    public String getAction() {
        return this.action;
    }

    public String getVersion() {
        return this.version;
    }

    public String toString() {
        return "ChangeActionVersion(action=" + this.getAction() + ", version=" + this.getVersion() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeActionVersion)) {
            return false;
        }
        ChangeActionVersion other = (ChangeActionVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$action = this.getAction();
        String other$action = other.getAction();
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChangeActionVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }
}

