/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openrewrite.ExecutionContext;
import org.openrewrite.HasSourcePath;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.yaml.JsonPathMatcher;
import org.openrewrite.yaml.YamlVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class SetupJavaUpgradeJavaVersion
extends Recipe {
    @Option(displayName="Minimum major Java version (defaults to 17)", example="17", required=false)
    @Nullable
    private final Integer minimumJavaMajorVersion;

    public String getDisplayName() {
        return "Upgrade `actions/setup-java` `java-version`";
    }

    public String getDescription() {
        return "Update the Java version used by `actions/setup-java` if it is below the expected version number.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new HasSourcePath(".github/workflows/*.yml");
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new UpgradeJavaVersionVisitor(this.minimumJavaMajorVersion == null ? 17 : this.minimumJavaMajorVersion);
    }

    public SetupJavaUpgradeJavaVersion(Integer minimumJavaMajorVersion) {
        this.minimumJavaMajorVersion = minimumJavaMajorVersion;
    }

    public Integer getMinimumJavaMajorVersion() {
        return this.minimumJavaMajorVersion;
    }

    public String toString() {
        return "SetupJavaUpgradeJavaVersion(minimumJavaMajorVersion=" + this.getMinimumJavaMajorVersion() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetupJavaUpgradeJavaVersion)) {
            return false;
        }
        SetupJavaUpgradeJavaVersion other = (SetupJavaUpgradeJavaVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$minimumJavaMajorVersion = this.getMinimumJavaMajorVersion();
        Integer other$minimumJavaMajorVersion = other.getMinimumJavaMajorVersion();
        return !(this$minimumJavaMajorVersion == null ? other$minimumJavaMajorVersion != null : !((Object)this$minimumJavaMajorVersion).equals(other$minimumJavaMajorVersion));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SetupJavaUpgradeJavaVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $minimumJavaMajorVersion = this.getMinimumJavaMajorVersion();
        result = result * 59 + ($minimumJavaMajorVersion == null ? 43 : ((Object)$minimumJavaMajorVersion).hashCode());
        return result;
    }

    private static class UpgradeJavaVersionVisitor
    extends YamlVisitor<ExecutionContext> {
        private static final JsonPathMatcher javaVersion = new JsonPathMatcher("..steps[?(@.uses =~ 'actions/setup-java@v*.*')].with.java-version");
        private static final Pattern javaVersionPattern = Pattern.compile("([0-9]+)(\\.[0-9]+)*([-+].*)?");
        private final int minimumJavaMajorVersion;

        public Yaml visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
            int currentMajorVersion;
            if (!javaVersion.matches(this.getCursor())) {
                return super.visitMappingEntry(entry, (Object)ctx);
            }
            Yaml.Scalar currentValue = (Yaml.Scalar)entry.getValue();
            Matcher matcher = javaVersionPattern.matcher(currentValue.getValue());
            if (!matcher.matches()) {
                return super.visitMappingEntry(entry, (Object)ctx);
            }
            try {
                currentMajorVersion = Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException ex) {
                return super.visitMappingEntry(entry, (Object)ctx);
            }
            if (currentMajorVersion >= this.minimumJavaMajorVersion) {
                return super.visitMappingEntry(entry, (Object)ctx);
            }
            return super.visitMappingEntry(entry.withValue((Yaml.Block)currentValue.withValue(String.valueOf(this.minimumJavaMajorVersion))), (Object)ctx);
        }

        public UpgradeJavaVersionVisitor(int minimumJavaMajorVersion) {
            this.minimumJavaMajorVersion = minimumJavaMajorVersion;
        }
    }
}

