/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github;

import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.HasSourcePath;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.yaml.JsonPathMatcher;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.YamlParser;
import org.openrewrite.yaml.YamlVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class AutoCancelInProgressWorkflow
extends Recipe {
    @Option(displayName="Access token", description="A repository or organization secret that contains a Github personal access token with permission to cancel workflows.", example="WORKFLOWS_ACCESS_TOKEN")
    private final String accessToken;

    public String getDisplayName() {
        return "Cancel in-progress workflow when it is triggered again";
    }

    public String getDescription() {
        return "When a workflow is already running and would be triggered again, cancel the existing workflow.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new HasSourcePath(".github/workflows/*.yml");
    }

    protected YamlVisitor<ExecutionContext> getVisitor() {
        final JsonPathMatcher firstStep = new JsonPathMatcher("$.jobs.build.steps[:1].uses");
        final JsonPathMatcher jobSteps = new JsonPathMatcher("$.jobs.build.steps[]");
        return new YamlIsoVisitor<ExecutionContext>(){

            public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext executionContext) {
                block2: {
                    block3: {
                        if (!firstStep.matches(this.getCursor())) break block2;
                        if (!(entry.getValue() instanceof Yaml.Scalar)) break block3;
                        if (((Yaml.Scalar)entry.getValue()).getValue().contains("cancel-workflow-action")) break block2;
                    }
                    this.getCursor().dropParentUntil(Yaml.Sequence.class::isInstance).putMessage("ADD_STEP", (Object)true);
                }
                return super.visitMappingEntry(entry, (Object)executionContext);
            }

            public Yaml.Sequence visitSequence(Yaml.Sequence sequence, ExecutionContext ctx) {
                Yaml.Sequence s = super.visitSequence(sequence, (Object)ctx);
                if (jobSteps.encloses(this.getCursor()) && Boolean.TRUE.equals(this.getCursor().getMessage("ADD_STEP"))) {
                    Yaml.Documents documents = (Yaml.Documents)new YamlParser().parse(ctx, new String[]{"- uses: styfle/cancel-workflow-action@0.8.0\n  with:\n    access_token: ${{secrets." + AutoCancelInProgressWorkflow.this.accessToken + "}}"}).get(0);
                    Yaml.Sequence.Entry cancelWorkflowAction = (Yaml.Sequence.Entry)((Yaml.Sequence)((Yaml.Document)documents.getDocuments().get(0)).getBlock()).getEntries().get(0);
                    cancelWorkflowAction = (Yaml.Sequence.Entry)this.autoFormat((Yaml)cancelWorkflowAction.withPrefix("\n"), ctx, this.getCursor());
                    return s.withEntries(ListUtils.concat((Object)cancelWorkflowAction, (List)s.getEntries()));
                }
                return s;
            }
        };
    }

    public AutoCancelInProgressWorkflow(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String toString() {
        return "AutoCancelInProgressWorkflow(accessToken=" + this.getAccessToken() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutoCancelInProgressWorkflow)) {
            return false;
        }
        AutoCancelInProgressWorkflow other = (AutoCancelInProgressWorkflow)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$accessToken = this.getAccessToken();
        String other$accessToken = other.getAccessToken();
        return !(this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AutoCancelInProgressWorkflow;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $accessToken = this.getAccessToken();
        result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
        return result;
    }
}

