/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.compiled.internal.signature;

import io.moderne.compiled.internal.signature.ArrayTypeSignature;
import io.moderne.compiled.internal.signature.ClassBound;
import io.moderne.compiled.internal.signature.ClassTypeSignature;
import io.moderne.compiled.internal.signature.InterfaceBound;
import io.moderne.compiled.internal.signature.TypeVariableSignature;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.java.JavaTypeVisitor;
import org.openrewrite.java.tree.JavaType;

public final class FormalTypeParameter {
    private final String identifier;
    private final ClassBound classBound;
    private final @Nullable List<InterfaceBound> interfaceBounds;

    public static FormalTypeParameter fromJavaType(JavaType.GenericTypeVariable gtv) {
        final AtomicReference<ClassBound> classBound = new AtomicReference<ClassBound>(ClassBound.NONE);
        final ArrayList<InterfaceBound> interfaceBounds = new ArrayList<InterfaceBound>();
        for (final JavaType bound : gtv.getBounds()) {
            new JavaTypeVisitor<Integer>(){
                boolean terminate;

                public @Nullable JavaType visit(@Nullable JavaType javaType, Integer integer) {
                    if (this.terminate) {
                        return javaType;
                    }
                    return super.visit(javaType, (Object)integer);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public JavaType visitClass(JavaType.Class aClass, Integer p) {
                    this.terminate = true;
                    if (aClass.getKind() == JavaType.FullyQualified.Kind.Interface) {
                        if (bound instanceof JavaType.FullyQualified) {
                            interfaceBounds.add(new InterfaceBound(ClassTypeSignature.fromJavaType((JavaType.FullyQualified)bound)));
                            return aClass;
                        } else if (bound instanceof JavaType.Array) {
                            interfaceBounds.add(new InterfaceBound(ArrayTypeSignature.fromJavaType((JavaType.Array)bound)));
                            return aClass;
                        } else {
                            if (!(bound instanceof JavaType.GenericTypeVariable)) throw new IllegalStateException("Unexpected formal type parameter of type " + bound.getClass().getSimpleName());
                            interfaceBounds.add(new InterfaceBound(new TypeVariableSignature(((JavaType.GenericTypeVariable)bound).getName())));
                        }
                        return aClass;
                    } else if (bound instanceof JavaType.FullyQualified) {
                        classBound.set(new ClassBound(ClassTypeSignature.fromJavaType((JavaType.FullyQualified)bound)));
                        return aClass;
                    } else {
                        if (!(bound instanceof JavaType.Array)) throw new IllegalStateException("Unexpected type parameter of type " + bound.getClass().getSimpleName());
                        classBound.set(new ClassBound(ArrayTypeSignature.fromJavaType((JavaType.Array)bound)));
                    }
                    return aClass;
                }
            }.visit(bound, Integer.valueOf(0));
        }
        if (classBound.get() == ClassBound.NONE && interfaceBounds.isEmpty()) {
            classBound.set(ClassBound.OBJECT);
        }
        return new FormalTypeParameter(gtv.getName(), classBound.get(), interfaceBounds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.identifier);
        sb.append(this.classBound);
        if (this.interfaceBounds != null) {
            for (InterfaceBound interfaceBound : this.interfaceBounds) {
                sb.append(interfaceBound);
            }
        }
        return sb.toString();
    }

    @Generated
    public FormalTypeParameter(String identifier, ClassBound classBound, @Nullable List<InterfaceBound> interfaceBounds) {
        this.identifier = identifier;
        this.classBound = classBound;
        this.interfaceBounds = interfaceBounds;
    }

    @Generated
    public String getIdentifier() {
        return this.identifier;
    }

    @Generated
    public ClassBound getClassBound() {
        return this.classBound;
    }

    @Generated
    public @Nullable List<InterfaceBound> getInterfaceBounds() {
        return this.interfaceBounds;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FormalTypeParameter)) {
            return false;
        }
        FormalTypeParameter other = (FormalTypeParameter)o;
        String this$identifier = this.getIdentifier();
        String other$identifier = other.getIdentifier();
        if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
            return false;
        }
        ClassBound this$classBound = this.getClassBound();
        ClassBound other$classBound = other.getClassBound();
        if (this$classBound == null ? other$classBound != null : !((Object)this$classBound).equals(other$classBound)) {
            return false;
        }
        List<InterfaceBound> this$interfaceBounds = this.getInterfaceBounds();
        List<InterfaceBound> other$interfaceBounds = other.getInterfaceBounds();
        return !(this$interfaceBounds == null ? other$interfaceBounds != null : !((Object)this$interfaceBounds).equals(other$interfaceBounds));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        ClassBound $classBound = this.getClassBound();
        result = result * 59 + ($classBound == null ? 43 : ((Object)$classBound).hashCode());
        List<InterfaceBound> $interfaceBounds = this.getInterfaceBounds();
        result = result * 59 + ($interfaceBounds == null ? 43 : ((Object)$interfaceBounds).hashCode());
        return result;
    }
}

