/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.compiled.internal;

import io.moderne.compiled.internal.signature.ClassSignature;
import io.moderne.compiled.internal.signature.FieldDescriptor;
import io.moderne.compiled.internal.signature.FieldTypeSignature;
import io.moderne.compiled.internal.signature.MethodDescriptor;
import io.moderne.compiled.internal.signature.MethodTypeSignature;
import io.moderne.compiled.internal.signature.ObjectType;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class JavaTypeClassWriter {
    public byte[] toABI(JavaType.FullyQualified aClass, JavaType.FullyQualified ... innerClasses) {
        ClassWriter classWriter = new ClassWriter(0);
        ClassSignature classSignature = ClassSignature.fromJavaType(aClass);
        classWriter.visit(52, this.writeAccess(aClass.getFlags()) | 0x20, aClass.getFullyQualifiedName().replace('.', '/'), classSignature.toString(), classSignature.getSuperclassSignature().getInternalName(), null);
        for (JavaType.FullyQualified innerClass : innerClasses) {
            classWriter.visitInnerClass(innerClass.getFullyQualifiedName().replace('.', '/'), innerClass.getOwningClass().getFullyQualifiedName().replace('.', '/'), innerClass.getClassName().substring(innerClass.getClassName().lastIndexOf(46) + 1), this.writeAccess(innerClass.getFlags()));
        }
        JavaType.Class c = (JavaType.Class)(aClass instanceof JavaType.Parameterized ? ((JavaType.Parameterized)aClass).getType() : aClass);
        for (JavaType.Variable member : c.getMembers()) {
            if ((member.getFlagsBitMap() & Flag.Private.getBitMask()) != 0L) continue;
            this.writeField(member, classWriter);
        }
        for (JavaType.Method method : c.getMethods()) {
            if ((method.getFlagsBitMap() & Flag.Private.getBitMask()) != 0L) continue;
            this.writeMethod(method, classWriter);
        }
        return classWriter.toByteArray();
    }

    void writeField(JavaType.Variable member, ClassWriter classWriter) {
        String fieldDescriptor;
        String fieldTypeSignature = FieldTypeSignature.fromJavaType(member.getType()).toString();
        if (fieldTypeSignature.equals(fieldDescriptor = FieldDescriptor.fromJavaType(member.getType()).toString())) {
            fieldTypeSignature = null;
        }
        classWriter.visitField(this.writeAccess(member.getFlags()), member.getName(), fieldDescriptor, fieldTypeSignature, null).visitEnd();
    }

    void writeMethod(JavaType.Method method, ClassWriter classWriter) {
        String descriptor = MethodDescriptor.fromJavaType(method).toString();
        String methodTypeSignature = MethodTypeSignature.fromJavaType(method).toString();
        List throwns = method.getThrownExceptions();
        String[] exceptions = null;
        if (!throwns.isEmpty()) {
            exceptions = new String[throwns.size()];
            for (int i = 0; i < throwns.size(); ++i) {
                JavaType thrown = (JavaType)throwns.get(i);
                if (thrown instanceof JavaType.GenericTypeVariable) {
                    thrown = (JavaType)((JavaType.GenericTypeVariable)thrown).getBounds().get(0);
                }
                exceptions[i] = ObjectType.fromJavaType(Objects.requireNonNull(TypeUtils.asFullyQualified((JavaType)thrown))).getInternalName();
            }
        }
        MethodVisitor methodVisitor = classWriter.visitMethod(this.writeAccess(method.getFlags()), method.isConstructor() ? "<init>" : method.getName(), descriptor, descriptor.equals(methodTypeSignature) ? null : methodTypeSignature, exceptions);
        for (String parameterName : method.getParameterNames()) {
            methodVisitor.visitParameter(parameterName, 0);
        }
        methodVisitor.visitEnd();
    }

    private int writeAccess(Collection<Flag> flags) {
        int access = 0;
        for (Flag flag : flags) {
            switch (flag) {
                case Public: {
                    access |= 1;
                    break;
                }
                case Private: {
                    access |= 2;
                    break;
                }
                case Protected: {
                    access |= 4;
                    break;
                }
                case Static: {
                    access |= 8;
                    break;
                }
                case Final: {
                    access |= 0x10;
                    break;
                }
                case Synchronized: {
                    access |= 0x20;
                    break;
                }
                case Volatile: {
                    access |= 0x40;
                    break;
                }
                case Transient: {
                    access |= 0x80;
                    break;
                }
                case Native: {
                    access |= 0x100;
                    break;
                }
                case Interface: {
                    access |= 0x200;
                    break;
                }
                case Abstract: {
                    access |= 0x400;
                    break;
                }
                case Strictfp: {
                    access |= 0x800;
                    break;
                }
                case Varargs: {
                    access |= 0x80;
                }
            }
        }
        return access;
    }
}

