/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.compiled.internal.signature;

import io.moderne.compiled.internal.signature.ClassTypeSignature;
import io.moderne.compiled.internal.signature.TypeSignature;
import io.moderne.compiled.internal.signature.TypeVariableSignature;
import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.openrewrite.java.tree.JavaType;

public class ThrowsSignature {
    TypeSignature typeSignature;

    public ThrowsSignature(ClassTypeSignature classTypeSignature) {
        this.typeSignature = classTypeSignature;
    }

    public ThrowsSignature(TypeVariableSignature typeVariableSignature) {
        this.typeSignature = typeVariableSignature;
    }

    public static @Nullable List<ThrowsSignature> fromJavaType(@Nullable List<? extends JavaType> thrownExceptions) {
        if (thrownExceptions == null || thrownExceptions.isEmpty()) {
            return null;
        }
        ArrayList<ThrowsSignature> throwsSignatures = new ArrayList<ThrowsSignature>(thrownExceptions.size());
        boolean throwsInvolvesTypeVariables = false;
        for (JavaType javaType : thrownExceptions) {
            TypeSignature thrownSignature = TypeSignature.fromJavaType(javaType);
            if (thrownSignature instanceof ClassTypeSignature) {
                if (((ClassTypeSignature)thrownSignature).getTypeArguments() != null) {
                    throwsInvolvesTypeVariables = true;
                }
                throwsSignatures.add(new ThrowsSignature((ClassTypeSignature)thrownSignature));
                continue;
            }
            if (thrownSignature instanceof TypeVariableSignature) {
                throwsInvolvesTypeVariables = true;
                throwsSignatures.add(new ThrowsSignature((TypeVariableSignature)thrownSignature));
                continue;
            }
            throw new IllegalStateException("Expected thrown signature to be either a class type or type variable signature but was " + thrownSignature);
        }
        if (!throwsInvolvesTypeVariables) {
            return null;
        }
        return throwsSignatures;
    }

    public String toString() {
        return "^" + this.typeSignature;
    }
}

