// For Library Version: 1.120.12

declare module "sap/sac/df/library" {}

declare module "sap/sac/df/changeHandler/MultiDimModelChangeHandler" {
  import { default as Control, $ControlSettings } from "sap/ui/mdc/Control";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import MultiDimModel from "sap/sac/df/model/MultiDimModel";

  /**
   * Control to handle changes of {@link sap.sac.df.model.MultiDimModel }. To store the changes in {@link sap.ui.fl.variants.VariantManagement }
   * you need to include this change handler control as a dependent somewhere in the view tree for which the
   * variant management is responsible. Each time the event `requestCompleted` is fired a new change will
   * be created. The method `registerMultiDimModel` needs to be called once to register the {@link sap.sac.df.model.MultiDimModel  }
   * to the change handler.
   *
   * @since 1.120
   * @experimental (since 1.120)
   */
  export default class MultiDimModelChangeHandler extends Control {
    /**
     * Constructor for a new `MultiDimModelChangeHandler`.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string
    );

    /**
     * Creates a new subclass of class sap.sac.df.changeHandler.MultiDimModelChangeHandler with name `sClassName`
     * and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.mdc.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, MultiDimModelChangeHandler>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.sac.df.changeHandler.MultiDimModelChangeHandler.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Register {@link sap.sac.df.model.MultiDimModel} for handling changes
     */
    registerMultiDimModel(oMultiDimModel: MultiDimModel): void;
    /**
     * Skip the triggering of the event `apply` once
     */
    skipApplyModelChangeOnce(): void;
  }
  /**
   * Describes the settings that can be provided to the MultiDimModelChangeHandler constructor.
   *
   * @experimental (since 1.120)
   */
  export interface $MultiDimModelChangeHandlerSettings
    extends $ControlSettings {}
}

declare module "sap/sac/df/FilterBar" {
  import {
    default as FilterBar1,
    $FilterBarSettings as $FilterBarSettings1,
  } from "sap/ui/mdc/FilterBar";

  import Event from "sap/ui/base/Event";

  import FieldDisplay from "sap/ui/mdc/enums/FieldDisplay";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * A Filter Bar based on Multidimensional Model
   *
   * @experimental (since 1.119)
   */
  export default class FilterBar extends FilterBar1 {
    /**
     * Constructor for a new Filter Bar.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.sac.df.FilterBar with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.mdc.FilterBar.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, FilterBar>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.sac.df.FilterBar.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:beforeFilterChange beforeFilterChange} event
     * of this `sap.sac.df.FilterBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.sac.df.FilterBar` itself.
     *
     * Fires before update variable of multidimension model after input value or open value help of variable.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachBeforeFilterChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: FilterBar$BeforeFilterChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.sac.df.FilterBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:beforeFilterChange beforeFilterChange} event
     * of this `sap.sac.df.FilterBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.sac.df.FilterBar` itself.
     *
     * Fires before update variable of multidimension model after input value or open value help of variable.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachBeforeFilterChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: FilterBar$BeforeFilterChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.sac.df.FilterBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:cancelFilterChange cancelFilterChange} event
     * of this `sap.sac.df.FilterBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.sac.df.FilterBar` itself.
     *
     * Fires when cancel change in the value help dialog.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachCancelFilterChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.sac.df.FilterBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:cancelFilterChange cancelFilterChange} event
     * of this `sap.sac.df.FilterBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.sac.df.FilterBar` itself.
     *
     * Fires when cancel change in the value help dialog.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachCancelFilterChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.sac.df.FilterBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:beforeFilterChange beforeFilterChange} event
     * of this `sap.sac.df.FilterBar`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachBeforeFilterChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: FilterBar$BeforeFilterChangeEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:cancelFilterChange cancelFilterChange} event
     * of this `sap.sac.df.FilterBar`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachCancelFilterChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:beforeFilterChange beforeFilterChange} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireBeforeFilterChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: FilterBar$BeforeFilterChangeEventParameters
    ): this;
    /**
     * Fires event {@link #event:cancelFilterChange cancelFilterChange} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireCancelFilterChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getDisplay display}.
     *
     * Defines whether the value and/or description of the field is shown and in which order.
     *
     * Default value is `ValueDescription`.
     *
     *
     * @returns Value of property `display`
     */
    getDisplay(): FieldDisplay | keyof typeof FieldDisplay;
    /**
     * Gets current value of property {@link #getMode mode}.
     *
     * Mode
     *
     * Default value is `"VariablesOfDataProvider"`.
     *
     *
     * @returns Value of property `mode`
     */
    getMode(): string;
    /**
     * Gets current value of property {@link #getMultiDimModelId multiDimModelId}.
     *
     * ID of multiDimModel
     *
     * Default value is `"om"`.
     *
     *
     * @returns Value of property `multiDimModelId`
     */
    getMultiDimModelId(): string;
    /**
     * Sets a new value for property {@link #getDisplay display}.
     *
     * Defines whether the value and/or description of the field is shown and in which order.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `ValueDescription`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDisplay(
      /**
       * New value for property `display`
       */
      sDisplay?: FieldDisplay | keyof typeof FieldDisplay
    ): this;
    /**
     * Sets a new value for property {@link #getMode mode}.
     *
     * Mode
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"VariablesOfDataProvider"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMode(
      /**
       * New value for property `mode`
       */
      sMode?: string
    ): this;
    /**
     * Sets a new value for property {@link #getMultiDimModelId multiDimModelId}.
     *
     * ID of multiDimModel
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"om"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMultiDimModelId(
      /**
       * New value for property `multiDimModelId`
       */
      sMultiDimModelId?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the FilterBar constructor.
   *
   * @experimental (since 1.119)
   */
  export interface $FilterBarSettings extends $FilterBarSettings1 {
    /**
     * ID of multiDimModel
     */
    multiDimModelId?: string | PropertyBindingInfo;

    /**
     * Mode
     */
    mode?: string | PropertyBindingInfo;

    /**
     * Defines whether the value and/or description of the field is shown and in which order.
     */
    display?:
      | (FieldDisplay | keyof typeof FieldDisplay)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Fires before update variable of multidimension model after input value or open value help of variable.
     */
    beforeFilterChange?: (oEvent: FilterBar$BeforeFilterChangeEvent) => void;

    /**
     * Fires when cancel change in the value help dialog.
     */
    cancelFilterChange?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the FilterBar#beforeFilterChange event.
   */
  export interface FilterBar$BeforeFilterChangeEventParameters {
    /**
     * Indicates whether value help dialog is going to open.
     */
    beforeValueHelpOpen?: boolean;
  }

  /**
   * Event object of the FilterBar#beforeFilterChange event.
   */
  export type FilterBar$BeforeFilterChangeEvent = Event<
    FilterBar$BeforeFilterChangeEventParameters,
    FilterBar
  >;

  /**
   * Parameters of the FilterBar#cancelFilterChange event.
   */
  export interface FilterBar$CancelFilterChangeEventParameters {}

  /**
   * Event object of the FilterBar#cancelFilterChange event.
   */
  export type FilterBar$CancelFilterChangeEvent = Event<
    FilterBar$CancelFilterChangeEventParameters,
    FilterBar
  >;
}

declare module "sap/sac/df/FlexAnalysis" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import FlexAnalysisPanel from "sap/sac/df/FlexAnalysisPanel";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import { CSSSize } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import SystemType from "sap/sac/df/types/SystemType";

  /**
   * Enables users to view, navigate and change multidimensional data exposed via InA.
   *
   * Overview:
   *
   * The user can view the data in a Table, navigate in the data via a context menu or builder panels The
   * data source that the FlexAnalysis consumes or renders has to be provided as a property value.
   *
   * @experimental
   */
  export default class FlexAnalysis extends Control {
    /**
     * Constructor for a new `FlexAnalysis`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string
    );

    /**
     * Creates a new subclass of class sap.sac.df.FlexAnalysis with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, FlexAnalysis>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.sac.df.FlexAnalysis.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some customPanel to the aggregation {@link #getCustomPanels customPanels}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addCustomPanel(
      /**
       * The customPanel to add; if empty, nothing is inserted
       */
      oCustomPanel: FlexAnalysisPanel
    ): this;
    /**
     * Binds property {@link #getDataProvider dataProvider} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindProperty ManagedObject.bindProperty} for a detailed description
     * of the possible properties of `oBindingInfo`
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindDataProvider(
      /**
       * The binding information
       */
      oBindingInfo: PropertyBindingInfo
    ): this;
    /**
     * Destroys all the customPanels in the aggregation {@link #getCustomPanels customPanels}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyCustomPanels(): this;
    /**
     * Gets current value of property {@link #getAutoUpdate autoUpdate}.
     *
     * Indicates if Flexible Analysis component automatically requests the ResultSet for the shown data source
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `autoUpdate`
     */
    getAutoUpdate(): boolean;
    /**
     * Gets current value of property {@link #getClientIdentifier clientIdentifier}.
     *
     * Client Identifier to be used for underlying InA queries
     *
     *
     * @returns Value of property `clientIdentifier`
     */
    getClientIdentifier(): string;
    /**
     * Gets current value of property {@link #getConfigId configId}.
     *
     * configuration Id
     *
     *
     * @returns Value of property `configId`
     */
    getConfigId(): string;
    /**
     * Gets current value of property {@link #getConfigObject configObject}.
     *
     * JSON object containing the configuration (alternative to configurationURI)
     *
     *
     * @returns Value of property `configObject`
     */
    getConfigObject(): object;
    /**
     * Gets current value of property {@link #getConfigurationURI configurationURI}.
     *
     * URI of the advanced configuration to be fetched
     *
     *
     * @returns Value of property `configurationURI`
     */
    getConfigurationURI(): string;
    /**
     * Gets content of aggregation {@link #getCustomPanels customPanels}.
     *
     * Custom panels for the flexible analysis control
     */
    getCustomPanels(): FlexAnalysisPanel[];
    /**
     * Gets current value of property {@link #getDataProvider dataProvider}.
     *
     * Name of the Data Provider from the corresponding MultiDimModel to be used
     *
     *
     * @returns Value of property `dataProvider`
     */
    getDataProvider(): any;
    /**
     * Gets current value of property {@link #getDataSource dataSource}.
     *
     * Data source (Query name/ View, InA model etc) to be used to get the data from
     *
     * Default value is `"$datasource"`.
     *
     *
     * @returns Value of property `dataSource`
     */
    getDataSource(): string;
    /**
     * Gets current value of property {@link #getEnvironment environment}.
     *
     * Additional Flag to be passed to the control TODO: Document the possibilities
     *
     * Default value is `[]`.
     *
     *
     * @returns Value of property `environment`
     */
    getEnvironment(): string[];
    /**
     * Gets current value of property {@link #getHeight height}.
     *
     * Height of the component
     *
     * Default value is `"100%"`.
     *
     *
     * @returns Value of property `height`
     */
    getHeight(): CSSSize;
    /**
     * Gets current value of property {@link #getHideDesignPanel hideDesignPanel}.
     *
     * Sets if the Design Panel of FlexAnalysis is hidden
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `hideDesignPanel`
     */
    getHideDesignPanel(): boolean;
    /**
     * Gets current value of property {@link #getHideFilterLine hideFilterLine}.
     *
     * Sets if the filter of FlexAnalysis is hidden
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `hideFilterLine`
     */
    getHideFilterLine(): boolean;
    /**
     * Gets current value of property {@link #getHideLandingPage hideLandingPage}.
     *
     * Sets if the landing page of FlexAnalysis is hidden
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `hideLandingPage`
     */
    getHideLandingPage(): boolean;
    /**
     * Gets current value of property {@link #getHideMenuBar hideMenuBar}.
     *
     * Sets if the menu bar of FlexAnalysis is hidden
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `hideMenuBar`
     */
    getHideMenuBar(): boolean;
    /**
     * Gets current value of property {@link #getHideSideNavigation hideSideNavigation}.
     *
     * Sets if the side navigation bar of FlexAnalysis is hidden
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `hideSideNavigation`
     */
    getHideSideNavigation(): boolean;
    /**
     * Gets current value of property {@link #getHideStatusBar hideStatusBar}.
     *
     * Sets if the status bar of FlexAnalysis is hidden
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `hideStatusBar`
     */
    getHideStatusBar(): boolean;
    /**
     * Gets current value of property {@link #getHideStylePanel hideStylePanel}.
     *
     * Sets if the Style Panel of FlexAnalysis is hidden
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `hideStylePanel`
     */
    getHideStylePanel(): boolean;
    /**
     * Gets current value of property {@link #getHideToolBar hideToolBar}.
     *
     * Sets if the toolbar of FlexAnalysis is hidden
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `hideToolBar`
     */
    getHideToolBar(): boolean;
    /**
     * Gets current value of property {@link #getImplicitVariableHandling implicitVariableHandling}.
     *
     * Indicates if the variable are handled internal handling by FlexAnalysis. If set to false it is done via
     * corresponding MultiDimModel
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `implicitVariableHandling`
     */
    getImplicitVariableHandling(): boolean;
    /**
     * Gets current value of property {@link #getKeepAliveInterval keepAliveInterval}.
     *
     * Interval to keep the InA session alive. values less than 1 deactivates the keep alive handling
     *
     * Default value is `0`.
     *
     *
     * @returns Value of property `keepAliveInterval`
     */
    getKeepAliveInterval(): int;
    /**
     * Gets current value of property {@link #getMultiDimModelId multiDimModelId}.
     *
     * Id of the MultiDimModel to use
     *
     * Default value is `"om"`.
     *
     *
     * @returns Value of property `multiDimModelId`
     */
    getMultiDimModelId(): string;
    /**
     * Gets current value of property {@link #getShowTitle showTitle}.
     *
     * Indicates Flexible Analysis component should display the component title
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `showTitle`
     */
    getShowTitle(): boolean;
    /**
     * Gets current value of property {@link #getStyleTemplateName styleTemplateName}.
     *
     * Indicates if the variable are handled internal handling by FlexAnalysis. If set to false it is done via
     * corresponding MultiDimModel
     *
     *
     * @returns Value of property `styleTemplateName`
     */
    getStyleTemplateName(): string;
    /**
     * Gets current value of property {@link #getSystemName systemName}.
     *
     * System to take data from. If not set or set to "local" current url will be used to determine the system
     *
     *
     * @returns Value of property `systemName`
     */
    getSystemName(): string;
    /**
     * Gets current value of property {@link #getSystemType systemType}.
     *
     * Type the system to connect to get data
     *
     * Default value is `BW`.
     *
     *
     * @returns Value of property `systemType`
     */
    getSystemType(): SystemType | keyof typeof SystemType;
    /**
     * Gets current value of property {@link #getTitle title}.
     *
     * Sets title to be shown in the control. If not set the name of the corresponding back-end query is used
     *
     *
     * @returns Value of property `title`
     */
    getTitle(): string;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Width of the component
     *
     * Default value is `"100%"`.
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Checks for the provided `sap.sac.df.FlexAnalysisPanel` in the aggregation {@link #getCustomPanels customPanels}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfCustomPanel(
      /**
       * The customPanel whose index is looked for
       */
      oCustomPanel: FlexAnalysisPanel
    ): int;
    /**
     * Inserts a customPanel into the aggregation {@link #getCustomPanels customPanels}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertCustomPanel(
      /**
       * The customPanel to insert; if empty, nothing is inserted
       */
      oCustomPanel: FlexAnalysisPanel,
      /**
       * The `0`-based index the customPanel should be inserted at; for a negative value of `iIndex`, the customPanel
       * is inserted at position 0; for a value greater than the current size of the aggregation, the customPanel
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getCustomPanels customPanels}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllCustomPanels(): FlexAnalysisPanel[];
    /**
     * Removes a customPanel from the aggregation {@link #getCustomPanels customPanels}.
     *
     *
     * @returns The removed customPanel or `null`
     */
    removeCustomPanel(
      /**
       * The customPanel to remove or its index or id
       */
      vCustomPanel: int | string | FlexAnalysisPanel
    ): FlexAnalysisPanel | null;
    /**
     * Sets a new value for property {@link #getAutoUpdate autoUpdate}.
     *
     * Indicates if Flexible Analysis component automatically requests the ResultSet for the shown data source
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAutoUpdate(
      /**
       * New value for property `autoUpdate`
       */
      bAutoUpdate?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getClientIdentifier clientIdentifier}.
     *
     * Client Identifier to be used for underlying InA queries
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setClientIdentifier(
      /**
       * New value for property `clientIdentifier`
       */
      sClientIdentifier: string
    ): this;
    /**
     * Sets a new value for property {@link #getConfigId configId}.
     *
     * configuration Id
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setConfigId(
      /**
       * New value for property `configId`
       */
      sConfigId: string
    ): this;
    /**
     * Sets a new value for property {@link #getConfigObject configObject}.
     *
     * JSON object containing the configuration (alternative to configurationURI)
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setConfigObject(
      /**
       * New value for property `configObject`
       */
      oConfigObject: object
    ): this;
    /**
     * Sets a new value for property {@link #getConfigurationURI configurationURI}.
     *
     * URI of the advanced configuration to be fetched
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setConfigurationURI(
      /**
       * New value for property `configurationURI`
       */
      sConfigurationURI: string
    ): this;
    /**
     * Sets a new value for property {@link #getDataProvider dataProvider}.
     *
     * Name of the Data Provider from the corresponding MultiDimModel to be used
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDataProvider(
      /**
       * New value for property `dataProvider`
       */
      oDataProvider: any
    ): this;
    /**
     * Sets a new value for property {@link #getDataSource dataSource}.
     *
     * Data source (Query name/ View, InA model etc) to be used to get the data from
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"$datasource"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDataSource(
      /**
       * New value for property `dataSource`
       */
      sDataSource?: string
    ): this;
    /**
     * Sets a new value for property {@link #getEnvironment environment}.
     *
     * Additional Flag to be passed to the control TODO: Document the possibilities
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `[]`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnvironment(
      /**
       * New value for property `environment`
       */
      sEnvironment?: string[]
    ): this;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * Height of the component
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"100%"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      sHeight?: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getHideDesignPanel hideDesignPanel}.
     *
     * Sets if the Design Panel of FlexAnalysis is hidden
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHideDesignPanel(
      /**
       * New value for property `hideDesignPanel`
       */
      bHideDesignPanel?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getHideFilterLine hideFilterLine}.
     *
     * Sets if the filter of FlexAnalysis is hidden
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHideFilterLine(
      /**
       * New value for property `hideFilterLine`
       */
      bHideFilterLine?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getHideLandingPage hideLandingPage}.
     *
     * Sets if the landing page of FlexAnalysis is hidden
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHideLandingPage(
      /**
       * New value for property `hideLandingPage`
       */
      bHideLandingPage?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getHideMenuBar hideMenuBar}.
     *
     * Sets if the menu bar of FlexAnalysis is hidden
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHideMenuBar(
      /**
       * New value for property `hideMenuBar`
       */
      bHideMenuBar?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getHideSideNavigation hideSideNavigation}.
     *
     * Sets if the side navigation bar of FlexAnalysis is hidden
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHideSideNavigation(
      /**
       * New value for property `hideSideNavigation`
       */
      bHideSideNavigation?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getHideStatusBar hideStatusBar}.
     *
     * Sets if the status bar of FlexAnalysis is hidden
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHideStatusBar(
      /**
       * New value for property `hideStatusBar`
       */
      bHideStatusBar?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getHideStylePanel hideStylePanel}.
     *
     * Sets if the Style Panel of FlexAnalysis is hidden
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHideStylePanel(
      /**
       * New value for property `hideStylePanel`
       */
      bHideStylePanel?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getHideToolBar hideToolBar}.
     *
     * Sets if the toolbar of FlexAnalysis is hidden
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHideToolBar(
      /**
       * New value for property `hideToolBar`
       */
      bHideToolBar?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getImplicitVariableHandling implicitVariableHandling}.
     *
     * Indicates if the variable are handled internal handling by FlexAnalysis. If set to false it is done via
     * corresponding MultiDimModel
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setImplicitVariableHandling(
      /**
       * New value for property `implicitVariableHandling`
       */
      bImplicitVariableHandling?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getKeepAliveInterval keepAliveInterval}.
     *
     * Interval to keep the InA session alive. values less than 1 deactivates the keep alive handling
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setKeepAliveInterval(
      /**
       * New value for property `keepAliveInterval`
       */
      iKeepAliveInterval?: int
    ): this;
    /**
     * Sets a new value for property {@link #getMultiDimModelId multiDimModelId}.
     *
     * Id of the MultiDimModel to use
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"om"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMultiDimModelId(
      /**
       * New value for property `multiDimModelId`
       */
      sMultiDimModelId?: string
    ): this;
    /**
     * Sets a new value for property {@link #getShowTitle showTitle}.
     *
     * Indicates Flexible Analysis component should display the component title
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowTitle(
      /**
       * New value for property `showTitle`
       */
      bShowTitle?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getStyleTemplateName styleTemplateName}.
     *
     * Indicates if the variable are handled internal handling by FlexAnalysis. If set to false it is done via
     * corresponding MultiDimModel
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setStyleTemplateName(
      /**
       * New value for property `styleTemplateName`
       */
      sStyleTemplateName: string
    ): this;
    /**
     * Sets a new value for property {@link #getSystemName systemName}.
     *
     * System to take data from. If not set or set to "local" current url will be used to determine the system
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSystemName(
      /**
       * New value for property `systemName`
       */
      sSystemName: string
    ): this;
    /**
     * Sets a new value for property {@link #getSystemType systemType}.
     *
     * Type the system to connect to get data
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `BW`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSystemType(
      /**
       * New value for property `systemType`
       */
      sSystemType?: SystemType | keyof typeof SystemType
    ): this;
    /**
     * Sets a new value for property {@link #getTitle title}.
     *
     * Sets title to be shown in the control. If not set the name of the corresponding back-end query is used
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTitle(
      /**
       * New value for property `title`
       */
      sTitle: string
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * Width of the component
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"100%"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth?: CSSSize
    ): this;
    /**
     * Unbinds property {@link #getDataProvider dataProvider} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindDataProvider(): this;
  }
  /**
   * Describes the settings that can be provided to the FlexAnalysis constructor.
   *
   * @experimental
   */
  export interface $FlexAnalysisSettings extends $ControlSettings {
    /**
     * Sets title to be shown in the control. If not set the name of the corresponding back-end query is used
     */
    title?: string | PropertyBindingInfo;

    /**
     * Indicates Flexible Analysis component should display the component title
     */
    showTitle?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Indicates if Flexible Analysis component automatically requests the ResultSet for the shown data source
     */
    autoUpdate?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * URI of the advanced configuration to be fetched
     */
    configurationURI?: string | PropertyBindingInfo;

    /**
     * JSON object containing the configuration (alternative to configurationURI)
     */
    configObject?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * configuration Id
     */
    configId?: string | PropertyBindingInfo;

    /**
     * Width of the component
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Height of the component
     */
    height?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Sets if the Design Panel of FlexAnalysis is hidden
     */
    hideDesignPanel?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Sets if the Style Panel of FlexAnalysis is hidden
     */
    hideStylePanel?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Sets if the menu bar of FlexAnalysis is hidden
     */
    hideMenuBar?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Sets if the status bar of FlexAnalysis is hidden
     */
    hideStatusBar?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Sets if the toolbar of FlexAnalysis is hidden
     */
    hideToolBar?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Sets if the filter of FlexAnalysis is hidden
     */
    hideFilterLine?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Sets if the side navigation bar of FlexAnalysis is hidden
     */
    hideSideNavigation?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Sets if the landing page of FlexAnalysis is hidden
     */
    hideLandingPage?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Additional Flag to be passed to the control TODO: Document the possibilities
     */
    environment?: string[] | PropertyBindingInfo | `{${string}}`;

    /**
     * System to take data from. If not set or set to "local" current url will be used to determine the system
     */
    systemName?: string | PropertyBindingInfo;

    /**
     * Data source (Query name/ View, InA model etc) to be used to get the data from
     */
    dataSource?: string | PropertyBindingInfo;

    /**
     * Type the system to connect to get data
     */
    systemType?:
      | (SystemType | keyof typeof SystemType)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Interval to keep the InA session alive. values less than 1 deactivates the keep alive handling
     */
    keepAliveInterval?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Client Identifier to be used for underlying InA queries
     */
    clientIdentifier?: string | PropertyBindingInfo;

    /**
     * Name of the Data Provider from the corresponding MultiDimModel to be used
     */
    dataProvider?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * Id of the MultiDimModel to use
     */
    multiDimModelId?: string | PropertyBindingInfo;

    /**
     * Indicates if the variable are handled internal handling by FlexAnalysis. If set to false it is done via
     * corresponding MultiDimModel
     */
    implicitVariableHandling?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Indicates if the variable are handled internal handling by FlexAnalysis. If set to false it is done via
     * corresponding MultiDimModel
     */
    styleTemplateName?: string | PropertyBindingInfo;

    /**
     * Custom panels for the flexible analysis control
     */
    customPanels?:
      | FlexAnalysisPanel[]
      | FlexAnalysisPanel
      | AggregationBindingInfo
      | `{${string}}`;
  }
}

declare module "sap/sac/df/FlexAnalysisPanel" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import Control from "sap/ui/core/Control";

  import { URI } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * A panel to be added into FlexAnalysis control
   *
   * @experimental
   */
  export default class FlexAnalysisPanel extends UI5Element {
    /**
     * Constructor for a new Flexible Analysis Panel.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $FlexAnalysisPanelSettings
    );
    /**
     * Constructor for a new Flexible Analysis Panel.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $FlexAnalysisPanelSettings
    );

    /**
     * Creates a new subclass of class sap.sac.df.FlexAnalysisPanel with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, FlexAnalysisPanel>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.sac.df.FlexAnalysisPanel.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Destroys the content in the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyContent(): this;
    /**
     * Gets content of aggregation {@link #getContent content}.
     *
     * The content of this panel
     */
    getContent(): Control;
    /**
     * Gets current value of property {@link #getDescription description}.
     *
     * The description of the panel, displayed as tooltip on the side navigation item.
     *
     *
     * @returns Value of property `description`
     */
    getDescription(): string;
    /**
     * Gets current value of property {@link #getIcon icon}.
     *
     * The icon of the panel, displayed on the side navigation item and the panel header.
     *
     *
     * @returns Value of property `icon`
     */
    getIcon(): URI;
    /**
     * Gets current value of property {@link #getTitle title}.
     *
     * The title of the panel header.
     *
     *
     * @returns Value of property `title`
     */
    getTitle(): string;
    /**
     * Sets the aggregated {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setContent(
      /**
       * The content to set
       */
      oContent: Control
    ): this;
    /**
     * Sets a new value for property {@link #getDescription description}.
     *
     * The description of the panel, displayed as tooltip on the side navigation item.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDescription(
      /**
       * New value for property `description`
       */
      sDescription: string
    ): this;
    /**
     * Sets a new value for property {@link #getIcon icon}.
     *
     * The icon of the panel, displayed on the side navigation item and the panel header.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIcon(
      /**
       * New value for property `icon`
       */
      sIcon: URI
    ): this;
    /**
     * Sets a new value for property {@link #getTitle title}.
     *
     * The title of the panel header.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTitle(
      /**
       * New value for property `title`
       */
      sTitle: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the FlexAnalysisPanel constructor.
   *
   * @experimental
   */
  export interface $FlexAnalysisPanelSettings extends $ElementSettings {
    /**
     * The description of the panel, displayed as tooltip on the side navigation item.
     */
    description?: string | PropertyBindingInfo;

    /**
     * The title of the panel header.
     */
    title?: string | PropertyBindingInfo;

    /**
     * The icon of the panel, displayed on the side navigation item and the panel header.
     */
    icon?: URI | PropertyBindingInfo | `{${string}}`;

    /**
     * The content of this panel
     */
    content?: Control;
  }
}

declare module "sap/sac/df/model/AxesLayout" {
  import BaseObject from "sap/ui/base/Object";

  import Metadata from "sap/ui/base/Metadata";

  /**
   * Axis Layout showing which dimensions are set on rows and which on columns.
   *
   * **Structure of Exposed Data:**
   * ```javascript
   *
   * "Rows": [],
   * "Columns": []
   * ```
   *
   *
   * @since 1.119
   * @experimental (since 1.119)
   */
  export default class AxesLayout extends BaseObject {
    constructor();

    /**
     * Creates a new subclass of class sap.sac.df.model.AxesLayout with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.base.Object.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, AxesLayout>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.sac.df.model.AxesLayout.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Distribute the dimension among the rows and columns
     *
     *
     * @returns resolving to the axes layout object to allow chaining
     */
    setAxesLayout(
      /**
       * an array containing the names of the dimensions on rows. The order in the array control the position
       * on the axis.
       */
      aDimensionOnRowsAxis: string[],
      /**
       * an array containing a containing the names of the dimensions on columns. The order in the array control
       * the position on the axis.
       */
      aDimensionOnColumnsAxis: string[]
    ): AxesLayout;
  }
}

declare module "sap/sac/df/model/DataProvider" {
  import BaseObject from "sap/ui/base/Object";

  import AxesLayout from "sap/sac/df/model/AxesLayout";

  import DataSourceInfo from "sap/sac/df/model/DataSourceInfo";

  import Dimension from "sap/sac/df/model/Dimension";

  import Grid from "sap/sac/df/model/Grid";

  import Variable from "sap/sac/df/model/Variable";

  import Metadata from "sap/ui/base/Metadata";

  /**
   * A data provider is an analytical query exposed via an analytical engine and accessed via InA protocol.
   * It represents a navigable query manager and allows to access and change data. Instances of this class
   * should only be created by the {@link sap.sac.df.model.MultiDimModel}.
   *
   * **Structure of Exposed Data:**
   * ```javascript
   *
   * "Name": "",
   * "DataSourceInfo": { },
   * "Variables": { }
   * "Dimensions": { },
   * "Measures": [ ],
   * "AxesLayout": {
   *   "Columns": [],
   *   "Rows": []
   *  },
   * "Grid": { },
   * "Messages": [ ]
   * ```
   *
   *
   * @since 1.119
   * @experimental (since 1.119)
   */
  export default class DataProvider extends BaseObject {
    constructor();
    /**
     * AxesLayout
     */
    AxesLayout: AxesLayout;

    /**
     * DataSourceInfo
     */
    DataSourceInfo: DataSourceInfo;

    /**
     * Dimensions
     */
    Dimensions: Record<string, Dimension>;

    /**
     * Grid
     */
    Grid: Grid;

    /**
     * Measures
     */
    Measures: Record<string, /* was: sap.sac.df.model.Measure */ any>;

    /**
     * Variables
     */
    Variables: Record<string, Variable>;

    /**
     * Creates a new subclass of class sap.sac.df.model.DataProvider with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.base.Object.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, DataProvider>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.sac.df.model.DataProvider.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Updates the multidimensional model from the given the state of a data provider
     *
     *
     * @returns Promise with reference to this in order to allow method chaining
     */
    deserialize(
      /**
       * the JSON object containing the persisted state of a data provider to be applied.
       */
      oModelState: object,
      /**
       * Format of the serialization (INA_REPOSITORY_DELTA or INA_REPOSITORY).
       */
      sFormat?: string,
      /**
       * Indicator if the data provider updated should be suppressed after deserialization
       */
      bSuppressUpdate?: boolean
    ): Promise<this>;
    /**
     * Export Data
     */
    exportData(
      /**
       * Data export configuration
       */
      oDataExportConfig: object
    ): void;
    /**
     * Get axis Layout
     *
     *
     * @returns Axis layout object
     */
    getAxesLayout(): AxesLayout;
    /**
     * Get data source information
     *
     *
     * @returns data source information object
     */
    getDataSourceInfo(): DataSourceInfo;
    /**
     * Get the scaling factor of a measure or cell
     *
     *
     * @returns Number of decimal places
     */
    getDecimalPlaces(
      /**
       * Measure structure member
       */
      sMeasureStructureMember: string,
      /**
       * Structure (non-measure) member
       */
      sStructureMember: string
    ): int;
    /**
     * Get Dimension
     *
     *
     * @returns Dimension object
     */
    getDimension(
      /**
       * Dimension name
       */
      sDimensionName: string
    ): Dimension;
    /**
     * Get all dimensions
     *
     *
     * @returns Object of all dimensions
     */
    getDimensions(): Record<string, Dimension>;
    /**
     * Get Grid
     *
     *
     * @returns Grid object
     */
    getGrid(): Grid;
    /**
     * Get measure
     *
     *
     * @returns Measure object
     */
    getMeasure(
      /**
       * Measure name
       */
      sMeasureName: string
    ): /* was: sap.sac.df.model.Measure */ any;
    /**
     * Get all measures
     *
     *
     * @returns Object of all measures
     */
    getMeasures(): /* was: sap.sac.df.model.Measure */ any;
    /**
     * Get Measure Structure Dimension
     *
     *
     * @returns Measure structure dimension
     */
    getMeasureStructureDimension(): Dimension;
    /**
     * Get result set
     */
    getResultSet(
      /**
       * Enforce result set update
       */
      bEnforceResultSetUpdate?: boolean
    ): void;
    /**
     * Get the scaling factor of a measure or cell
     *
     *
     * @returns Scaling factor
     */
    getScalingFactor(
      /**
       * Measure structure member
       */
      sMeasureStructureMember: string,
      /**
       * Structure (non-measure) member
       */
      sStructureMember: string
    ): int;
    /**
     * Get structure (non-measure) dimension
     *
     *
     * @returns Structure dimension object
     */
    getStructureDimension(): Dimension;
    /**
     * Get Variable
     *
     *
     * @returns Variable object
     */
    getVariable(
      /**
       * Variable Name
       */
      sVariableName: string
    ): Variable;
    /**
     * Get all variables
     *
     *
     * @returns Object of all variables
     */
    getVariables(): Record<string, Variable>;
    /**
     * Serialize the data provider state to a JSON representation
     *
     *
     * @returns A JSON object which represents the data provider
     */
    serialize(
      /**
       * Format of the serialization (INA_REPOSITORY_DELTA or INA_REPOSITORY)
       */
      sFormat?: string
    ): object;
    /**
     * Set the number of decimal places of a measure or cell
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    setDecimalPlaces(
      /**
       * Number of the decimal places
       */
      nNumberOfDecimalPlaces: int,
      /**
       * Measure structure member
       */
      sMeasureStructureMember: string,
      /**
       * Structure (non-measure) member
       */
      sStructureMember: string
    ): this;
    /**
     * Set the scaling factor of a measure or cell
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    setScalingFactor(
      /**
       * Scaling factor
       */
      nFactor: int,
      /**
       * Measure structure member
       */
      sMeasureStructureMember: string,
      /**
       * Structure (non-measure) member
       */
      sStructureMember: string
    ): this;
    /**
     * Checks whether an InA capability is supported by the server. Throws an error for unhandled capabilities.
     * List of handled capabilities can be seen in type {@link sap.sac.df.model.Capability}
     *
     *
     * @returns Returns true, if the capability is supported, else false
     */
    supportsCapability(
      /**
       * Capability name
       */
      sCapability: undefined
    ): boolean;
  }
}

declare module "sap/sac/df/model/DataSourceInfo" {
  import BaseObject from "sap/ui/base/Object";

  import Metadata from "sap/ui/base/Metadata";

  /**
   * Data source information.
   *
   * **Structure of Exposed Data:**
   * ```javascript
   *
   *  "QueryTitle": "",
   *  "QueryName": "",
   *  "QueryType": "",
   *  "SystemName": "",
   *  "CreatedBy": "",
   *  "CreatedOn": "",
   *  "QueryDueDateText": "",
   *  "CreatedOnText": "",
   *  "QueryDueDate": "",
   *  "ResultAlignmentRows": "",
   *  "ResultAlignmentColumns": "",
   *  "LastUpdated": "",
   *  "LastUpdatedBy": "",
   *  "LastUpdatedText": ""
   * ```
   *
   *
   * @since 1.119
   * @experimental (since 1.119)
   */
  export default class DataSourceInfo extends BaseObject {
    constructor();

    /**
     * Creates a new subclass of class sap.sac.df.model.DataSourceInfo with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.base.Object.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, DataSourceInfo>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.sac.df.model.DataSourceInfo.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
  }
}

declare module "sap/sac/df/model/Dimension" {
  import BaseObject from "sap/ui/base/Object";

  import Metadata from "sap/ui/base/Metadata";

  /**
   * Dimension Object
   *
   * **Structure of Exposed Data:**
   * ```javascript
   *
   * "Name": "",
   * "TechName": "",
   * "Description": "",
   * "Axis": "",
   * "Type": "",
   * "HierarchyActive": "",
   * "HasFilter": "",
   * "MemberFilter": [],
   * "SortDirection": "",
   * "Position": "",
   * "LastPosition": "",
   * "IsStructure": "",
   * "IsMeasureStructure": "",
   * "ValueType": "",
   * "SemanticObject": "",
   * "Members": [{
   *   "Key": "",
   *   "Name": "",
   *   "TechName": "",
   *   "Description": "",
   *   "SemanticObject": "
   * }]
   * ```
   *
   *
   * @since 1.119
   * @experimental (since 1.119)
   */
  export default class Dimension extends BaseObject {
    constructor();

    /**
     * Creates a new subclass of class sap.sac.df.model.Dimension with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.base.Object.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Dimension>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.sac.df.model.Dimension.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Set Display Type of Dimension
     *
     *
     * @returns } resolving to the Dimension to allow chaining.
     */
    static setDimensionDisplay(
      /**
       * level
       */
      sDisplayType: string
    ): Dimension;
    /**
     * Add dimension filters
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    addMemberFilter(
      /**
       * a member filter object
       */
      oMemberFilter: /* was: sap.sac.df.model.MemberFilter */ any,
      /**
       * If true, the result set is invalidated and must be refreshed
       */
      bInvalidateDataProvider: boolean
    ): this;
    /**
     * Add a member filter by its key
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    addMemberFilterByKey(
      /**
       * (internal) key of a dimension member
       */
      sKey: string,
      /**
       * If true, the result set is invalidated and must be refreshed
       */
      bInvalidateDataProvider: boolean
    ): this;
    /**
     * Clear the filter of a dimension
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    clearMemberFilter(
      /**
       * If true, the result set is invalidated and must be refreshed
       */
      bInvalidateDataProvider: boolean
    ): this;
    /**
     * Get effective dimension filters
     *
     *
     * @returns array of member filters
     */
    getMemberFilter(): /* was: sap.sac.df.model.MemberFilter */ any[];
    /**
     * Move dimension one position down on it's axis
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    moveDown(): this;
    /**
     * Move dimension one position up on it's axis
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    moveUp(): this;
    /**
     * Open a dialog to display and change the settings of a dimension of the `DataProvider`
     *
     *
     * @returns indicator whether the dialog was confirmed or canceled
     */
    openPropertyDialog(): Promise<boolean>;
    /**
     * Open a dialog to display and change the filter on a dimension
     *
     *
     * @returns resolving to a boolean which is false when the dialog is cancelled and true if is was closed
     * with Ok and dynamic filters of the given dimension are updated
     */
    openValueHelpDialog(
      /**
       * If true, the result set is invalidated and must be refreshed
       */
      bInvalidateDataProvider: boolean
    ): Promise<any>;
    /**
     * Set Display Hierarchy
     *
     *
     * @returns resolving to the `Dimension` to allow chaining.
     */
    readHierarchy(
      /**
       * level
       */
      iLevel: int
    ): Dimension;
    /**
     * Remove a drill operation on a dimension member
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    removeDrilldown(): this;
    /**
     * Remove the filter of a dimension
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    removeMemberFilter(
      /**
       * a member filter object
       */
      oMemberFilter: /* was: sap.sac.df.model.MemberFilter */ any,
      /**
       * If true, the result set is invalidated and must be refreshed
       */
      bInvalidateDataProvider: boolean
    ): this;
    /**
     * Remove a member filter by its key
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    removeMemberFilterByKey(
      /**
       * (internal) key of a dimension member
       */
      sKey: string,
      /**
       * If true, the result set is invalidated and must be refreshed
       */
      bInvalidateDataProvider: boolean
    ): this;
    /**
     * Performs the search for a given value
     *
     *
     * @returns array of found member filters
     */
    searchMember(
      /**
       * string to search for
       */
      sSearchString: string,
      /**
       * if a fuzzy search is performed
       */
      bFuzzy: boolean,
      /**
       * if to search in text/description (default true)
       */
      bText: boolean,
      /**
       * if to search in key/id (default true)
       */
      bKey: boolean,
      /**
       * maximal number of search results (default 1)
       */
      iMaxNumberOfResults: int,
      /**
       * if to provide the parents of the search result for hierarchical variables (only relevant if iMaxNumberOfResults
       * is set)
       */
      bRequestParents: boolean
    ): Promise</* was: sap.sac.df.MemberFilter */ any[]>;
    /**
     * Set Display Hierarchy
     *
     *
     * @returns resolving to the `Dimension` to allow chaining.
     */
    setDisplayHierarchy(
      /**
       * whether the hierarchy should be activated
       */
      bActive: boolean,
      /**
       * the name of the hierarchy (optional)
       */
      sHierarchyName: string,
      /**
       * the version of the hierarchy (optional)
       */
      sVersion: string
    ): Dimension;
    /**
     * Set dimension filters
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    setMemberFilter(
      /**
       * array of member filters
       */
      aMemberFilter: /* was: sap.sac.df.model.MemberFilter */ any[],
      /**
       * If true, the result set is invalidated and must be refreshed
       */
      bInvalidateDataProvider: boolean
    ): this;
    /**
     * Set a member filter by its key
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    setMemberFilterByKey(
      /**
       * (internal) key of a dimension member
       */
      sKey: string,
      /**
       * If true, the result set is invalidated and must be refreshed
       */
      bInvalidateDataProvider: boolean
    ): this;
    /**
     * Sort the members of a dimension
     *
     *
     * @returns Promise referencing to this in order to allow method chaining
     */
    sort(
      /**
       * of sorting
       */
      type: /* was: sap.sac.df.types.SortType */ any,
      /**
       * of sorting
       */
      direction: /* was: sap.sac.df.types.SortDirection */ any,
      /**
       * in case of a structure the measure according to which is sorted
       */
      sMember?: string
    ): Promise<Dimension>;
    /**
     * Move dimension to the columns axis
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    toColumns(): this;
    /**
     * Move dimension to the rows axis
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    toRows(): this;
  }
}

declare module "sap/sac/df/model/Document" {
  import BaseObject from "sap/ui/base/Object";

  import Metadata from "sap/ui/base/Metadata";

  /**
   * Document Object
   *
   * @since 1.119
   * @experimental (since 1.119)
   */
  export default class Document extends BaseObject {
    constructor();

    /**
     * Creates a new subclass of class sap.sac.df.model.Document with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.base.Object.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Document>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.sac.df.model.Document.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Creates a document in the document store
     *
     *
     * @returns a promise which resolves to true if create operation is successful, otherwise false.
     */
    createDocument(
      /**
       * the document ID
       */
      sDocumentId: undefined,
      /**
       * the content of the document
       */
      sContent: undefined
    ): Promise<boolean>;
    /**
     * Creates a document ID for a data cell in the result set
     *
     *
     * @returns a promise which resolves with the newly created document ID
     */
    createDocumentId(
      /**
       * the row index
       */
      nRowIndex: int,
      /**
       * the column index
       */
      nColumnIndex: int
    ): Promise<String>;
    /**
     * Deletes a document in the document store
     *
     *
     * @returns a promise which resolves to true if delete operation is successful, otherwise false.
     */
    deleteDocument(
      /**
       * the document ID
       */
      sDocumentId: undefined
    ): Promise<boolean>;
    /**
     * Deletes a document ID for a data cell in the result set
     *
     *
     * @returns a promise which resolves to true if the delete operation is successful, otherwise false.
     */
    deleteDocumentId(
      /**
       * the row index
       */
      nRowIndex: int,
      /**
       * the column index
       */
      nColumnIndex: int
    ): Promise<boolean>;
    /**
     * Gets a document ID of a data cell in the result set
     *
     *
     * @returns a promise which resolves with the document ID
     */
    getDocumentId(
      /**
       * the row index
       */
      nRowIndex: int,
      /**
       * the column index
       */
      nColumnIndex: int
    ): Promise<String>;
    /**
     * Gets the type of DocumentsSupport.
     *
     *
     * @returns DocumentsSupport type
     */
    getDocumentsSupportType(): string;
    /**
     * Retrieves a document from the document store
     *
     *
     * @returns a promise which resolves with the version(s) of the document.
     */
    retrieveDocument(
      /**
       * the document ID
       */
      sDocumentId: undefined,
      /**
       * the version of the document - if version is not supplied, returns all versions.
       */
      sVersion: undefined
    ): Promise<object>;
    /**
     * Retrieves multiple documents from the document store
     *
     *
     * @returns a promise which resolves with all documents and its versions.
     */
    retrieveMultipleDocuments(
      /**
       * the array of document IDs
       */
      aDocumentIds: undefined
    ): Promise<object>;
    /**
     * Updates a document in the document store
     *
     *
     * @returns a promise which resolves to true if update operation is successful, otherwise false.
     */
    updateDocument(
      /**
       * the document ID
       */
      sDocumentId: undefined,
      /**
       * the content of the document
       */
      sContent: undefined
    ): Promise<boolean>;
  }
}

declare module "sap/sac/df/model/Grid" {
  import BaseObject from "sap/ui/base/Object";

  import Document from "sap/sac/df/model/Document";

  import Metadata from "sap/ui/base/Metadata";

  /**
   * Grid Object
   *
   * @since 1.119
   * @experimental (since 1.119)
   */
  export default class Grid extends BaseObject {
    constructor();
    /**
     * Documents
     */
    Documents: Document;

    /**
     * Creates a new subclass of class sap.sac.df.model.Grid with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.base.Object.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Grid>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.sac.df.model.Grid.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Gets the cell context for a data cell in the result set
     *
     *
     * @returns a promise which resolves with the retrieved cell context
     */
    getCellContext(
      /**
       * the row index
       */
      nRowIndex: int,
      /**
       * the column index
       */
      nColumnIndex: int
    ): Promise<Object>;
    /**
     * Get the list of the jump targets associated to a cell defined via the Report-To-Report Interface.
     *
     *
     * @returns resolving to the List of jump targets.
     */
    getRRITargets(
      /**
       * Row of the data cell
       */
      iRowIndex: int,
      /**
       * Column of the data cell
       */
      iColumnIndex: int
    ): Promise<any>;
  }
}

declare module "sap/sac/df/model/MultiDimModel" {
  import JSONModel from "sap/ui/model/json/JSONModel";

  import DataProvider from "sap/sac/df/model/DataProvider";

  import Message from "sap/ui/core/message/Message";

  import VariableGroup from "sap/sac/df/model/VariableGroup";

  import DataSourceType from "sap/sac/df/types/DataSourceType";

  import Metadata from "sap/ui/base/Metadata";

  import Event from "sap/ui/base/Event";

  /**
   * The multidimensional model allows to access and change data accessed via the InA Protocol. The multidimensional
   * model populate it's exposed data in JSON format via binding to controls.
   *
   * **Structure of Exposed Data:**
   * ```javascript
   *
   * "DataProviders": { },
   * "VariableGroups": { },
   * "Messages": [ ]
   * ```
   *
   *
   * @since 1.119
   * @experimental (since 1.119)
   */
  export default class MultiDimModel extends JSONModel {
    /**
     * Constructor for a new MultiDimModel. After model creation you need to wait for the event {@link #event:loaded loaded}.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control.
       */
      mSettings?: object
    );
    /**
     * Data Providers
     */
    DataProviders: Record<string, DataProvider>;

    /**
     * Messages
     */
    Messages: Message[];

    /**
     * Variable Groups
     */
    VariableGroups: Record<string, VariableGroup>;

    /**
     * Creates a new subclass of class sap.sac.df.model.MultiDimModel with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.model.json.JSONModel.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, MultiDimModel>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.sac.df.model.MultiDimModel.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Creates a new data provider and attaches it to the model.
     *
     *
     * @returns Promise which resolves the created data provider
     */
    addDataProvider(
      /**
       * Data provider name
       */
      sDataProviderName: string,
      /**
       * Datasource name which the data provider is supposed to expose
       */
      sDataSourceName: string,
      /**
       * System name
       */
      sSystem?: string,
      /**
       * Package name
       */
      sPackage?: string,
      /**
       * Schema name
       */
      sSchema?: string,
      /**
       * Data source type
       */
      sDataSourceType?: DataSourceType | keyof typeof DataSourceType
    ): Promise<DataProvider>;
    /**
     * Creates a new variable group and attaches it to the model.
     *
     * A variable group defines which variables of the underlying data providers should behave as the same variable.
     * The group is defined by a name and a rule. The first added variable becomes automatically the `MergedVariable`.
     *
     *
     * @returns Promise which resolves the created variable group
     */
    addVariableGroup(
      /**
       * Variable group name
       */
      sVariableGroupName: string,
      /**
       * Rule is a function which accept the variable definition and decides if the variable has to be part of
       * te group.
       */
      fnRule: Function,
      /**
       * Additional properties
       */
      oProperties: Object
    ): Promise<VariableGroup>;
    /**
     * Updates the model from the given the model state including all aggregated data providers
     *
     *
     * @returns Promise with reference to this in order to allow method chaining
     */
    deserialize(
      /**
       * A JSON object which represents the multidimensional model to be applied
       */
      oModelState: object,
      /**
       * Format of the serialization (INA_REPOSITORY_DELTA or INA_REPOSITORY).
       */
      sFormat?: string
    ): Promise<this>;
    /**
     * Fires event {@link #event:dataProviderAdded dataProviderAdded} to attached listeners.
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    fireDataProviderAdded(
      /**
       * Parameters to pass along with the event
       */
      oParameters?: object
    ): this;
    /**
     * Fires event {@link #event:dataProviderRemoved dataProviderRemoved} to attached listeners.
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    fireDataProviderRemoved(
      /**
       * Parameters to pass along with the event
       */
      oParameters?: object
    ): this;
    /**
     * Fires event {@link #event:dataProviderUpdated dataProviderUpdated} to attached listeners.
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    fireDataProviderUpdated(
      /**
       * Parameters to pass along with the event
       */
      oParameters?: object
    ): this;
    /**
     * Get a data provider
     *
     *
     * @returns Data provider instance if found
     */
    getDataProvider(
      /**
       * Data provider name
       */
      sDataProviderName: string
    ): DataProvider;
    /**
     * Get all data providers
     *
     *
     * @returns Object of all data providers
     */
    getDataProviders(): Record<string, DataProvider>;
    /**
     * Get all messages
     *
     *
     * @returns Array of messages
     */
    getMessages(): Message[];
    /**
     * Get a variable group
     *
     *
     * @returns Variable group object
     */
    getVariableGroup(
      /**
       * Variable group name
       */
      sVariableGroupName: string
    ): VariableGroup;
    /**
     * Get all variable groups
     *
     *
     * @returns Object of all variable groups
     */
    getVariableGroups(): Record<string, VariableGroup>;
    /**
     * Ensures all aggregated DataProviders are logged off.
     *
     *
     * @returns Promise which resolves when logoff is finished.
     */
    logoff(): Promise<void>;
    /**
     * Remove existing data provider from the model.
     *
     *
     * @returns Promise which resolves when the removing s finished
     */
    removeDataProvider(
      /**
       * Data provider name to be removed
       */
      sDataProviderName: string
    ): Promise<void>;
    /**
     * Remove a variable group from the model
     *
     *
     * @returns Promise which resolves when the removing s finished
     */
    removeVariableGroup(
      /**
       * Variable group name
       */
      sVariableGroupName: string
    ): Promise<void>;
    /**
     * Reset the model to the initial state
     *
     *
     * @returns Promise which resolves when reset is finished.
     */
    resetModel(): Promise<void>;
    /**
     * Serialize the model with all aggregated data providers to a JSON representation
     *
     *
     * @returns A JSON object which represents the multidimensional model
     */
    serialize(
      /**
       * Format of the serialization (INA_REPOSITORY_DELTA or INA_REPOSITORY)
       */
      sFormat?: string
    ): object;
    /**
     * Resets the messages
     */
    setMessages(
      /**
       * The new messages for the model, mapping a binding path to an array of sap.ui.core.message.Message objects
       */
      mMessages: Record<string, Message[]>
    ): void;
  }
  /**
   * Parameters of the MultiDimModel#dataProviderAdded event.
   */
  export interface MultiDimModel$DataProviderAddedEventParameters {}

  /**
   * Event object of the MultiDimModel#dataProviderAdded event.
   */
  export type MultiDimModel$DataProviderAddedEvent = Event<
    MultiDimModel$DataProviderAddedEventParameters,
    MultiDimModel
  >;

  /**
   * Parameters of the MultiDimModel#dataProviderRemoved event.
   */
  export interface MultiDimModel$DataProviderRemovedEventParameters {}

  /**
   * Event object of the MultiDimModel#dataProviderRemoved event.
   */
  export type MultiDimModel$DataProviderRemovedEvent = Event<
    MultiDimModel$DataProviderRemovedEventParameters,
    MultiDimModel
  >;

  /**
   * Parameters of the MultiDimModel#dataProviderUpdated event.
   */
  export interface MultiDimModel$DataProviderUpdatedEventParameters {}

  /**
   * Event object of the MultiDimModel#dataProviderUpdated event.
   */
  export type MultiDimModel$DataProviderUpdatedEvent = Event<
    MultiDimModel$DataProviderUpdatedEventParameters,
    MultiDimModel
  >;

  /**
   * Parameters of the MultiDimModel#loaded event.
   */
  export interface MultiDimModel$LoadedEventParameters {}

  /**
   * Event object of the MultiDimModel#loaded event.
   */
  export type MultiDimModel$LoadedEvent = Event<
    MultiDimModel$LoadedEventParameters,
    MultiDimModel
  >;
}

declare module "sap/sac/df/model/Variable" {
  import BaseObject from "sap/ui/base/Object";

  import Metadata from "sap/ui/base/Metadata";

  /**
   * Variable Object
   *
   * **Structure of Exposed Data:**
   * ```javascript
   *
   * "Name": "",
   * "Dimension": "",
   * "ValueType": "",
   * "VariableType": "",
   * "Description": "",
   * "Mandatory": "",
   * "SupportsMultipleValues": "",
   * "TechName": "",
   * "InputEnabled": "",
   * "Position": ""
   * "SupportsValueHelp": "",
   * "DataProviderName": "",
   * "MemberFilter": []
   * ```
   *
   *
   * @since 1.119
   * @experimental (since 1.119)
   */
  export default class Variable extends BaseObject {
    constructor();

    /**
     * Creates a new subclass of class sap.sac.df.model.Variable with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.base.Object.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Variable>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.sac.df.model.Variable.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Add variable filters
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    addMemberFilter(
      /**
       * a member filter object
       */
      oMemberFilter: /* was: sap.sac.df.model.MemberFilter */ any,
      /**
       * If true, the result set is invalidated and must be refreshed
       */
      bInvalidateDataProvider: boolean
    ): this;
    /**
     * Add a member filter by its key
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    addMemberFilterByKey(
      /**
       * (internal) key of a dimension member
       */
      sKey: string,
      /**
       * If true, the result set is invalidated and must be refreshed
       */
      bInvalidateDataProvider: boolean
    ): this;
    /**
     * Clear variable filter
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    clearMemberFilter(
      /**
       * If true, the result set is invalidated and must be refreshed
       */
      bInvalidateDataProvider: boolean
    ): this;
    /**
     * Get effective variable filters
     *
     *
     * @returns array of member filters
     */
    getMemberFilter(): /* was: sap.sac.df.model.MemberFilter */ any[];
    /**
     * Open a dialog to display and change the filter on a variable
     *
     *
     * @returns resolving to a boolean which is false when the dialog is cancelled and true if is was closed
     * with Ok and dynamic filters of the given dimension are updated
     */
    openValueHelpDialog(
      /**
       * If true, the result set is invalidated and must be refreshed
       */
      bInvalidateDataProvider: boolean
    ): Promise<any>;
    /**
     * Remove variable filter
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    removeMemberFilter(
      /**
       * a member filter object
       */
      oMemberFilter: /* was: sap.sac.df.model.MemberFilter */ any,
      /**
       * If true, the result set is invalidated and must be refreshed
       */
      bInvalidateDataProvider: boolean
    ): this;
    /**
     * Remove a member filter by its key
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    removeMemberFilterByKey(
      /**
       * (internal) key of a dimension member
       */
      sKey: string,
      /**
       * If true, the result set is invalidated and must be refreshed
       */
      bInvalidateDataProvider: boolean
    ): this;
    /**
     * Performs the search for a given value
     *
     *
     * @returns array of found member filters
     */
    searchMember(
      /**
       * string to search for
       */
      sSearchString: string,
      /**
       * if a fuzzy search is performed
       */
      bFuzzy: boolean,
      /**
       * if to search in text/description (default true)
       */
      bText: boolean,
      /**
       * if to search in key/id (default true)
       */
      bKey: boolean,
      /**
       * maximal number of search results (default 1)
       */
      iMaxNumberOfResults: int,
      /**
       * if to provide the parents of the search result for hierarchical variables (only relevant if iMaxNumberOfResults
       * is set)
       */
      bRequestParents: boolean
    ): Promise</* was: sap.sac.df.MemberFilter */ any[]>;
    /**
     * Set variable filters
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    setMemberFilter(
      /**
       * array of member filters
       */
      aMemberFilter: /* was: sap.sac.df.model.MemberFilter */ any[],
      /**
       * If true, the result set is invalidated and must be refreshed
       */
      bInvalidateDataProvider: boolean
    ): this;
    /**
     * Set a member filter by its key
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    setMemberFilterByKey(
      /**
       * (internal) key of a dimension member
       */
      sKey: string,
      /**
       * If true, the result set is invalidated and must be refreshed
       */
      bInvalidateDataProvider: boolean
    ): this;
  }
}

declare module "sap/sac/df/model/VariableGroup" {
  import BaseObject from "sap/ui/base/Object";

  import Variable from "sap/sac/df/model/Variable";

  import Metadata from "sap/ui/base/Metadata";

  /**
   * Variable Group Object
   *
   * **Structure of Exposed Data:**
   * ```javascript
   *
   * "Name": "",
   * "MergedVariable": { },
   * "Rule: function () {}
   * ```
   *
   *
   * @since 1.119
   * @experimental (since 1.119)
   */
  export default class VariableGroup extends BaseObject {
    constructor();
    /**
     * Merged Variable
     */
    MergedVariable: Variable;

    /**
     * Name
     */
    Name: string;

    /**
     * Creates a new subclass of class sap.sac.df.model.VariableGroup with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.base.Object.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, VariableGroup>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.sac.df.model.VariableGroup.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Add variable group filters
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    addMemberFilter(
      /**
       * a member filter object
       */
      oMemberFilter: /* was: sap.sac.df.model.MemberFilter */ any,
      /**
       * If true, the result set is invalidated and must be refreshed
       */
      bInvalidateDataProvider: boolean
    ): this;
    /**
     * Add a member filter by its key
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    addMemberFilterByKey(
      /**
       * (internal) key of a dimension member
       */
      sKey: string,
      /**
       * If true, the result set is invalidated and must be refreshed
       */
      bInvalidateDataProvider: boolean
    ): this;
    /**
     * Clear variable group filter
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    clearMemberFilter(
      /**
       * If true, the result set is invalidated and must be refreshed
       */
      bInvalidateDataProvider: boolean
    ): this;
    /**
     * Get effective variable group filters
     *
     *
     * @returns array of member filters
     */
    getMemberFilter(): /* was: sap.sac.df.model.MemberFilter */ any[];
    /**
     * Opens the value help dialog so the user choose a value for a variable group After the value is selected
     * only teh VariableGroup.MergedVariable is updated. The variables of the aggregated DataProviders are updated
     * with the next ResultSet fetch
     *
     *
     * @returns to indicate if the VariableGroup has been updated
     */
    openValueHelpDialog(
      /**
       * If true, the result set is invalidated and must be refreshed
       */
      bInvalidateDataProvider: boolean
    ): Promise<boolean>;
    /**
     * Remove variable group filter
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    removeMemberFilter(
      /**
       * a member filter object
       */
      oMemberFilter: /* was: sap.sac.df.model.MemberFilter */ any,
      /**
       * If true, the result set is invalidated and must be refreshed
       */
      bInvalidateDataProvider: boolean
    ): this;
    /**
     * Remove a member filter by its key
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    removeMemberFilterByKey(
      /**
       * (internal) key of a dimension member
       */
      sKey: string,
      /**
       * If true, the result set is invalidated and must be refreshed
       */
      bInvalidateDataProvider: boolean
    ): this;
    /**
     * Performs the search in values of a given Variable
     *
     *
     * @returns array with found values
     */
    searchMember(
      /**
       * string to search for
       */
      sSearchString: string,
      /**
       * if a fuzzy search is performed
       */
      bFuzzy: boolean,
      /**
       * if to search in text/description (default true)
       */
      bText: boolean,
      /**
       * if to search in key/id (default true)
       */
      bKey: boolean,
      /**
       * maximal number of search results (default 1)
       */
      iMaxNumberOfResults: int,
      /**
       * if to provide the parents of the search result for hierarchical variables (only relevant if iMaxNumberOfResults
       * is set)
       */
      bRequestParents: boolean
    ): Promise</* was: sap.sac.df.model.MemberFilter */ any[]>;
    /**
     * Set variable group filters
     *
     *
     * @returns Promise which resolve when the value is set
     */
    setMemberFilter(
      /**
       * array of member filters
       */
      aMemberFilter: /* was: sap.sac.df.model.MemberFilter */ any[],
      /**
       * If true, the result set is invalidated and must be refreshed
       */
      bInvalidateDataProvider: boolean
    ): undefined;
    /**
     * Set a member filter by its key
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    setMemberFilterByKey(
      /**
       * (internal) key of a dimension member
       */
      sKey: string,
      /**
       * If true, the result set is invalidated and must be refreshed
       */
      bInvalidateDataProvider: boolean
    ): this;
  }
}

declare module "sap/sac/df/types/DataSourceType" {
  /**
   * Type of a data source
   */
  enum DataSourceType {
    /**
     * CDS Projection View
     */
    CDSProjectionView = "CDSProjectionView",
    /**
     * Cube
     */
    Cube = "Cube",
    /**
     * Ina Model
     */
    InAModel = "InAModel",
    /**
     * Query
     */
    Query = "Query",
    /**
     * View
     */
    View = "View",
  }
  export default DataSourceType;
}

declare module "sap/sac/df/types/SystemType" {
  /**
   * System Type of an InA System
   */
  enum SystemType {
    /**
     * The ABAP analytic engine
     */
    ABAP_MDS = "ABAP_MDS",
    /**
     * The BW analytic engine
     */
    BW = "BW",
    /**
     * The Data Warehouce Cloud analytic engine
     */
    DWC = "DWC",
    /**
     * The HANA/MDS analytic engine
     */
    HANA = "HANA",
  }
  export default SystemType;
}

declare namespace sap {
  interface IUI5DefineDependencyNames {
    "sap/sac/df/changeHandler/MultiDimModelChangeHandler": undefined;

    "sap/sac/df/FilterBar": undefined;

    "sap/sac/df/FlexAnalysis": undefined;

    "sap/sac/df/FlexAnalysisPanel": undefined;

    "sap/sac/df/library": undefined;

    "sap/sac/df/model/AxesLayout": undefined;

    "sap/sac/df/model/DataProvider": undefined;

    "sap/sac/df/model/DataSourceInfo": undefined;

    "sap/sac/df/model/Dimension": undefined;

    "sap/sac/df/model/Document": undefined;

    "sap/sac/df/model/Grid": undefined;

    "sap/sac/df/model/MultiDimModel": undefined;

    "sap/sac/df/model/Variable": undefined;

    "sap/sac/df/model/VariableGroup": undefined;

    "sap/sac/df/types/DataSourceType": undefined;

    "sap/sac/df/types/SystemType": undefined;
  }
}
