// For Library Version: 1.120.19

declare module "sap/fe/core/AppComponent" {
  import {
    default as UIComponent,
    $UIComponentSettings,
  } from "sap/ui/core/UIComponent";

  import { IAsyncContentCreation } from "sap/ui/core/library";

  /**
   * Main class for components used for an application in SAP Fiori elements.
   * Application developers using the templates and building blocks provided by SAP Fiori elements should
   * create their apps by extending this component.
   * This ensures that all the necessary services that you need for the building blocks and templates to work
   * properly are started.
   * When you use sap.fe.core.AppComponent as the base component, you also need to use a rootView. SAP Fiori
   * elements provides two options:
   *
   *  - sap.fe.core.rootView.NavContainer when using sap.m.routing.Router
   *
   *  - sap.fe.core.rootView.Fcl when using sap.f.routing.Router (FCL use case)
   */
  export default class AppComponent
    extends UIComponent
    implements IAsyncContentCreation {
    __implements__sap_ui_core_IAsyncContentCreation: boolean;

    constructor();

    /**
     * Changes the page configuration of SAP Fiori elements.
     * This method enables you to change the page configuration of SAP Fiori elements.
     */
    changePageConfiguration(
      /**
       * The ID of the page for which the configuration is to be changed.
       */
      pageId: string,
      /**
       * The path in the page settings for which the configuration is to be changed.
       */
      path: string,
      /**
       * The new value of the configuration. This could be a plain value like a string, or a Boolean, or a structured
       * object.
       */
      value: unknown
    ): void;
    /**
     * Provides a hook to initialize feature toggles.
     * This hook is being called by the SAP Fiori elements AppComponent at the time feature toggles can be initialized.
     * To change page configuration use the {@link sap.fe.core.AppComponent#changePageConfiguration } method.
     *
     *
     *
     * @returns A promise without any value to allow asynchronous processes
     */
    initializeFeatureToggles(): Promise<void>;
  }
  /**
   * Describes the settings that can be provided to the AppComponent constructor.
   */
  export interface $AppComponentSettings extends $UIComponentSettings {}
}

declare module "sap/fe/core/BaseController" {
  import Controller from "sap/ui/core/mvc/Controller";

  import AppComponent from "sap/fe/core/AppComponent";

  import Model from "sap/ui/model/Model";

  import View from "sap/ui/core/mvc/View";

  /**
   * Internal base controller class for SAP Fiori elements application.
   * If you want to extend a base controller for your custom page, please use for sap.fe.core.PageController.
   *
   *
   * @since 1.90.0
   */
  export default class BaseController extends Controller {
    constructor();

    /**
     * Returns the current app component.
     *
     * @since 1.91.0
     *
     * @returns The app component or, if not found, null
     */
    getAppComponent(): AppComponent;
    /**
     * Convenience method provided by SAP Fiori elements to enable applications to include the view model by
     * name into each controller.
     */
    getModel(
      /**
       * The model name
       */
      sName?: string
    ): void;
    /**
     * Convenience method for setting the view model in every controller of the application.
     *
     *
     * @returns The view instance
     */
    setModel(
      /**
       * The model instance
       */
      oModel: Model,
      /**
       * The model name
       */
      sName: string
    ): View;
  }
}

declare module "sap/fe/core/ExtensionAPI" {
  import BaseObject from "sap/ui/base/Object";

  import Control from "sap/ui/core/Control";

  import UI5Element from "sap/ui/core/Element";

  import EditFlow from "sap/fe/core/controllerextensions/EditFlow";

  import IntentBasedNavigation from "sap/fe/core/controllerextensions/IntentBasedNavigation";

  import Model from "sap/ui/model/Model";

  import Routing from "sap/fe/core/controllerextensions/Routing";

  import Context from "sap/ui/model/Context";

  /**
   * Common Extension API for all pages of SAP Fiori elements for OData V4.
   * To correctly integrate your app extension coding with SAP Fiori elements, use only the extensionAPI of
   * SAP Fiori elements. Don't access or manipulate controls, properties, models, or other internal objects
   * created by the SAP Fiori elements framework.
   *
   *
   * @since 1.79.0
   */
  export default class ExtensionAPI extends BaseObject {
    constructor();

    /**
     * Add any control as a dependent control to this SAP Fiori elements page.
     */
    addDependent(
      /**
       * Control to be added as a dependent control
       */
      oControl: Control
    ): void;
    /**
     * Access a control by its ID. If you attempt to access an internal control instead of the stable API, the
     * method will raise an error.
     *
     *
     * @returns The requested control, if found in the view / section.
     */
    byId(
      /**
       * ID of the control without view and section prefix.
       */
      id: string
    ): UI5Element | undefined;
    /**
     * Retrieves the editFlow controller extension for this page.
     *
     *
     * @returns The editFlow controller extension
     */
    getEditFlow(): EditFlow;
    /**
     * Retrieves the intentBasedNavigation controller extension for this page.
     *
     *
     * @returns The intentBasedNavigation controller extension
     */
    getIntentBasedNavigation(): IntentBasedNavigation;
    /**
     * Get access to models managed by SAP Fiori elements.
     *
     * The following models can be accessed:
     *
     *
     * 	 - undefined: the undefined model returns the SAPUI5 OData V4 model bound to this page
     *
     * 	 - i18n / further data models defined in the manifest
     * ui: returns a SAPUI5 JSON model containing UI information.
     * Only the following properties are public and supported:
     *
     *
     * 	 - isEditable: set to true if the application is in edit mode
     *
     *
     * .
     * editMode is deprecated and should not be used anymore. Use isEditable instead.
     *
     *
     * @returns The required model
     */
    getModel(
      /**
       * Name of the model
       */
      sModelName?: string
    ): Model | undefined;
    /**
     * Retrieves the routing controller extension for this page.
     *
     *
     * @returns The routing controller extension
     */
    getRouting(): Routing;
    /**
     * Load a fragment and go through the template preprocessor with the current page context.
     *
     *
     * @returns The fragment definition
     */
    loadFragment(
      /**
       * The settings object
       */
      mSettings: {
        /**
         * The contextPath to be used for the templating process
         */
        contextPath?: string;
        /**
         * The controller to be attached to the fragment
         */
        controller?: object;
        /**
         * The ID of the fragment itself
         */
        id: string;
        /**
         * The initial binding context
         */
        initialBindingContext?: Context;
        /**
         * The name of the fragment to be loaded
         */
        name: string;
      }
    ): Promise<UI5Element | UI5Element[]>;
    /**
     * Navigate to another target.
     */
    navigateToTarget(
      /**
       * Name of the target route
       */
      sTarget: string,
      /**
       * Context instance
       */
      oContext: Context
    ): void;
    /**
     * Remove a dependent control from this SAP Fiori elements page.
     */
    removeDependent(
      /**
       * Control to be added as a dependent control
       */
      oControl: Control
    ): void;
    /**
     * Triggers an update of the app state.
     * Should be called if the state of a control, or any other state-relevant information, was changed.
     *
     *
     * @returns A promise that resolves with the new app state object.
     */
    updateAppState(): Promise<object | void>;
  }
}

declare module "sap/fe/core/library" {
  /**
   * Possible initial load (first app startup) modes for a ListReport.
   *
   * @since 1.86.0
   */
  export enum InitialLoadMode {
    /**
     * Data will be loaded initially if filters are set.
     */
    Auto = "undefined",
    /**
     * Data will not be loaded initially.
     */
    Disabled = "undefined",
    /**
     * Data will be loaded initially.
     */
    Enabled = "undefined",
  }
}

declare module "sap/fe/core/PageController" {
  import BaseController from "sap/fe/core/BaseController";

  import ExtensionAPI from "sap/fe/core/ExtensionAPI";

  /**
   * Base controller class for your custom page used inside an SAP Fiori elements application.
   * This controller provides preconfigured extensions that will ensure you have the basic functionalities
   * required to use the building blocks.
   *
   *
   * @since 1.88.0
   */
  export default class PageController extends BaseController {
    constructor();

    /**
     * Get the extension API for the current page.
     *
     *
     * @returns The extension API.
     */
    getExtensionAPI(): ExtensionAPI;
  }
}

declare module "sap/fe/core/controllerextensions/BaseControllerExtension" {
  import ControllerExtension from "sap/ui/core/mvc/ControllerExtension";

  /**
   * A base implementation for controller extension used internally in sap.fe for central functionalities.
   *
   * @since 1.118.0
   */
  export default class BaseControllerExtension extends ControllerExtension {
    constructor();
  }
}

declare module "sap/fe/core/controllerextensions/EditFlow" {
  import BaseControllerExtension from "sap/fe/core/controllerextensions/BaseControllerExtension";

  import Context from "sap/ui/model/odata/v4/Context";

  import ODataListBinding from "sap/ui/model/odata/v4/ODataListBinding";

  import ODataModel from "sap/ui/model/odata/v4/ODataModel";

  /**
   * A controller extension offering hooks into the edit flow of the application
   *
   * @since 1.90.0
   */
  export default class EditFlow extends BaseControllerExtension {
    constructor();

    /**
     * Submit the current set of changes and navigate back.
     *
     * @since 1.90.0
     *
     * @returns Promise resolves once the changes have been saved
     */
    applyDocument(
      /**
       * Context of the document
       */
      oContext: Context
    ): Promise<void>;
    /**
     * Discard the editable document.
     *
     * @since 1.90.0
     *
     * @returns Promise resolves once editable document has been discarded
     */
    cancelDocument(
      /**
       * Context of the editable document
       */
      oContext: Context,
      /**
       * Can contain the following attributes:
       */
      mParameters: {
        /**
         * This is the control used to open the discard popover
         */
        control?: object;
        /**
         * Optional, supresses the discard popover and allows custom handling
         */
        skipDiscardPopover?: boolean;
      }
    ): Promise<any>;
    /**
     * Creates a new document.
     *
     * @since 1.90.0
     *
     * @returns Promise resolves once the object has been created
     */
    createDocument(
      /**
       * ODataListBinding object or the binding path for a temporary list binding
       */
      vListBinding: ODataListBinding | string,
      /**
       * Contains the following attributes:
       */
      mInParameters: {
        /**
         * Specifies if the new entry should be created at the top or bottom of a table in case of creationMode
         * 'Inline'
         */
        createAtEnd?: boolean;
        /**
         * The creation mode using one of the following:
         *
         * NewPage - the created document is shown in a new page, depending on whether metadata 'Sync', 'Async'
         * or 'Deferred' is used
         *
         * Inline - The creation is done inline (in a table)
         *
         * External - The creation is done in a different application specified via the parameter 'outbound'
         */
        creationMode: string;
        /**
         * The initial data for the created document
         */
        data?: object;
        /**
         * The navigation target where the document is created in case of creationMode 'External'
         */
        outbound?: string;
        /**
         * The contexts that are selected in the table initiating the creation. Used in case of a TreeTable to determine
         * the parent context of the created document
         */
        selectedContexts?: Context[];
        /**
         * When enabled, an extra request checks if any drafts exist that were never saved. If unsaved drafts are
         * found, the newest one is opened. If no unsaved drafts are found, a new entity is created
         */
        singleDraftForCreate?: boolean;
        /**
         * ID of the table
         */
        tableId?: string;
      }
    ): Promise<void>;
    /**
     * Deletes the document.
     *
     * @since 1.90.0
     *
     * @returns Promise resolves once document has been deleted
     */
    deleteDocument(
      /**
       * Context of the document
       */
      oContext: Context,
      /**
       * Can contain the following attributes:
       */
      mInParameters: {
        /**
         * Description of the object being deleted
         */
        description: string;
        /**
         * Title of the object being deleted
         */
        title: string;
      }
    ): Promise<void>;
    /**
     * Creates a draft document for the existing active document.
     *
     * @since 1.90.0
     *
     * @returns Promise resolved once the editable document is available with the editable context
     */
    editDocument(
      /**
       * Context of the active document
       */
      context: Context
    ): Promise<Context | void>;
    /**
     * Invokes an action (bound or unbound) and tracks the changes so that other pages can be refreshed and
     * show the updated data upon navigation.
     *
     * @since 1.90.0
     *
     * @returns A promise which resolves once the action has been executed, providing the response
     */
    invokeAction(
      /**
       * The name of the action to be called
       */
      sActionName: string,
      /**
       * Contains the following attributes:
       */
      mInParameters?: {
        /**
         * For a bound action, a context or an array with contexts for which the action is to be called must be
         * provided
         */
        contexts?: Context | Context[];
        /**
         * Mode how actions are to be called: 'ChangeSet' to put all action calls into one changeset, 'Isolated'
         * to put them into separate changesets
         */
        invocationGrouping?: string;
        /**
         * A human-readable label for the action. This is needed in case the action has a parameter and a parameter
         * dialog is shown to the user. The label will be used for the title of the dialog and for the confirmation
         * button
         */
        label?: string;
        /**
         * For an unbound action, an instance of an OData V4 model must be provided
         */
        model?: ODataModel;
        /**
         * A map of action parameter names and provided values
         */
        parameterValues?: {
          /**
           * Name of the parameter
           */
          name: string;
          /**
           * Value of the parameter
           */
          value: any;
        };
        /**
         * Boolean value indicating whether navigation is required after the action has been executed. Navigation
         * takes place to the context returned by the action
         */
        requiresNavigation?: boolean;
        /**
         * Skips the action parameter dialog if values are provided for all of them in parameterValues
         */
        skipParameterDialog?: boolean;
      }
    ): Promise<void>;
    /**
     * This function can be used to execute code after the 'Create' action.
     * You can execute custom coding in this function.
     * This function is meant to be individually overridden by consuming controllers, but not to be called directly.
     * The override execution is: {@link sap.ui.core.mvc.OverrideExecution.After }.
     *
     *
     * @since 1.116.0
     *
     * @returns A promise to be returned by the overridden method.
     */
    onAfterCreate(
      /**
       * Object containing the parameters passed to onBeforeCreate
       */
      _mParameters?: {
        /**
         * The newly created context
         */
        context?: Context;
      }
    ): Promise<void>;
    /**
     * This function can be used to execute code after the 'Delete' action.
     * You can execute custom coding in this function.
     * This function is meant to be individually overridden by consuming controllers, but not to be called directly.
     * The override execution is: {@link sap.ui.core.mvc.OverrideExecution.After }.
     *
     *
     * @since 1.116.0
     *
     * @returns A promise to be returned by the overridden method.
     */
    onAfterDelete(
      /**
       * Object containing the parameters passed to onBeforeDelete
       */
      _mParameters?: {
        /**
         * An array of contexts that are going to be deleted
         */
        contexts?: Context[];
      }
    ): Promise<void>;
    /**
     * This function can be used to execute code after the 'Discard' action.
     * You can execute custom coding in this function.
     * This function is meant to be individually overridden by consuming controllers, but not to be called directly.
     * The override execution is: {@link sap.ui.core.mvc.OverrideExecution.After }.
     *
     *
     * @since 1.116.0
     *
     * @returns A promise to be returned by the overridden method.
     */
    onAfterDiscard(
      /**
       * Object containing the parameters passed to onBeforeDiscard
       */
      _mParameters?: {
        /**
         * The context obtained after discarding the object, or undefined if we discarded a new object
         */
        context?: Context;
      }
    ): Promise<void>;
    /**
     * This function can be used to execute code after the 'Edit' action.
     * You can execute custom coding in this function.
     * This function is meant to be individually overridden by consuming controllers, but not to be called directly.
     * The override execution is: {@link sap.ui.core.mvc.OverrideExecution.After }.
     *
     *
     * @since 1.116.0
     *
     * @returns A promise to be returned by the overridden method.
     */
    onAfterEdit(
      /**
       * Object containing the parameters passed to onBeforeEdit
       */
      _mParameters?: {
        /**
         * Page context that is going to be edited.
         */
        context?: Context;
      }
    ): Promise<void>;
    /**
     * This function can be used to execute code after the 'Save' action.
     * You can execute custom coding in this function.
     * This function is meant to be individually overridden by consuming controllers, but not to be called directly.
     * The override execution is: {@link sap.ui.core.mvc.OverrideExecution.After }.
     *
     *
     * @since 1.116.0
     *
     * @returns A promise to be returned by the overridden method.
     */
    onAfterSave(
      /**
       * Object containing the parameters passed to onBeforeSave
       */
      _mParameters?: {
        /**
         * The context we obtained after saving
         */
        context?: Context;
      }
    ): Promise<void>;
    /**
     * This function can be used to intercept the 'Create' action. You can execute custom coding in this function.
     * The framework waits for the returned promise to be resolved before continuing the 'Create' action.
     * If you reject the promise, the 'Create' action is stopped.
     * This function is meant to be individually overridden by consuming controllers, but not to be called directly.
     * The override execution is: {@link sap.ui.core.mvc.OverrideExecution.After }.
     *
     *
     * @since 1.98.0
     *
     * @returns A promise to be returned by the overridden method. If resolved, the 'Create' action is triggered.
     * If rejected, the 'Create' action is not triggered.
     */
    onBeforeCreate(
      /**
       * Object containing the parameters passed to onBeforeCreate
       */
      _mParameters?: {
        /**
         * Path pointing to the context on which Create action is triggered
         */
        contextPath?: string;
        /**
         * Array of values that are filled in the Action Parameter Dialog
         */
        createParameters?: any[];
      }
    ): Promise<void>;
    /**
     * This function can be used to intercept the 'Delete' action. You can execute custom coding in this function.
     * The framework waits for the returned promise to be resolved before continuing the 'Delete' action.
     * If you reject the promise, the 'Delete' action is stopped.
     * This function is meant to be individually overridden by consuming controllers, but not to be called directly.
     * The override execution is: {@link sap.ui.core.mvc.OverrideExecution.After }.
     *
     *
     * @since 1.98.0
     *
     * @returns A promise to be returned by the overridden method. If resolved, the 'Delete' action is triggered.
     * If rejected, the 'Delete' action is not triggered.
     */
    onBeforeDelete(
      /**
       * Object containing the parameters passed to onBeforeDelete
       */
      _mParameters?: {
        /**
         * An array of contexts that are going to be deleted
         */
        contexts?: Context[];
      }
    ): Promise<void>;
    /**
     * This function can be used to intercept the 'Discard' action. You can execute custom coding in this function.
     * The framework waits for the returned promise to be resolved before continuing the 'Discard' action.
     * If you reject the promise, the 'Discard' action is stopped and the user stays in edit mode.
     * This function is meant to be individually overridden by consuming controllers, but not to be called directly.
     * The override execution is: {@link sap.ui.core.mvc.OverrideExecution.After }.
     *
     *
     * @since 1.98.0
     *
     * @returns A promise to be returned by the overridden method. If resolved, the 'Discard' action is triggered.
     * If rejected, the 'Discard' action is not triggered and the user stays in edit mode.
     */
    onBeforeDiscard(
      /**
       * Object containing the parameters passed to onBeforeDiscard
       */
      _mParameters?: {
        /**
         * Page context that is going to be discarded.
         */
        context?: Context;
      }
    ): Promise<void>;
    /**
     * This function can be used to intercept the 'Edit' action. You can execute custom coding in this function.
     * The framework waits for the returned promise to be resolved before continuing the 'Edit' action.
     * If you reject the promise, the 'Edit' action is stopped and the user stays in display mode.
     * This function is meant to be individually overridden by consuming controllers, but not to be called directly.
     * The override execution is: {@link sap.ui.core.mvc.OverrideExecution.After }.
     *
     *
     * @since 1.98.0
     *
     * @returns A promise to be returned by the overridden method. If resolved, the 'Edit' action is triggered.
     * If rejected, the 'Edit' action is not triggered and the user stays in display mode.
     */
    onBeforeEdit(
      /**
       * Object containing the parameters passed to onBeforeEdit
       */
      _mParameters?: {
        /**
         * Page context that is going to be edited.
         */
        context?: Context;
      }
    ): Promise<void>;
    /**
     * This function can be used to intercept the 'Save' action. You can execute custom coding in this function.
     * The framework waits for the returned promise to be resolved before continuing the 'Save' action.
     * If you reject the promise, the 'Save' action is stopped and the user stays in edit mode.
     * This function is meant to be individually overridden by consuming controllers, but not to be called directly.
     * The override execution is: {@link sap.ui.core.mvc.OverrideExecution.After }.
     *
     *
     * @since 1.90.0
     *
     * @returns A promise to be returned by the overridden method. If resolved, the 'Save' action is triggered.
     * If rejected, the 'Save' action is not triggered and the user stays in edit mode.
     */
    onBeforeSave(
      /**
       * Object containing the parameters passed to onBeforeSave
       */
      _mParameters?: {
        /**
         * Page context that is going to be saved.
         */
        context?: Context;
      }
    ): Promise<void>;
    /**
     * Saves a new document after checking it.
     *
     * @since 1.90.0
     *
     * @returns Promise resolves once save is complete
     */
    saveDocument(
      /**
       * Context of the editable document
       */
      oContext: Context
    ): Promise<void>;
    /**
     * Secured execution of the given function. Ensures that the function is only executed when certain conditions
     * are fulfilled.
     *
     * @since 1.90.0
     *
     * @returns A promise that is rejected if the execution is prohibited and resolved by the promise returned
     * by the fnFunction.
     */
    securedExecution(
      /**
       * The function to be executed. Should return a promise that is settled after completion of the execution.
       * If nothing is returned, immediate completion is assumed.
       */
      fnFunction: Function,
      /**
       * Definitions of the preconditions to be checked before execution
       */
      mParameters?: {
        /**
         * Defines the busy indicator
         */
        busy?: {
          /**
           * Executes function only if application isn't busy.
           */
          check?: boolean;
          /**
           * Triggers a busy indicator when the function is executed.
           */
          set?: boolean;
        };
        /**
         * This operation updates the current document without using the bound model and context. As a result, the
         * draft status is updated if a draft document exists, and the user has to confirm the cancellation of the
         * editing process.
         */
        updatesDocument?: boolean;
      }
    ): Promise<void>;
    /**
     * Updates the draft status and displays the error messages if there are errors during an update.
     *
     * @since 1.90.0
     *
     * @returns Promise resolves once draft status has been updated
     */
    updateDocument(
      /**
       * Context of the updated field
       */
      updatedContext: object,
      /**
       * Promise to determine when the update operation is completed. The promise should be resolved when the
       * update operation is completed, so the draft status can be updated.
       */
      updatePromise: Promise<any>
    ): Promise<void>;
  }
}

declare module "sap/fe/core/controllerextensions/IntentBasedNavigation" {
  import ControllerExtension from "sap/ui/core/mvc/ControllerExtension";

  import SelectionVariant from "sap/fe/navigation/SelectionVariant";

  /**
   * Controller extension providing hooks for intent-based navigation
   *
   * @since 1.86.0
   */
  export default class IntentBasedNavigation extends ControllerExtension {
    constructor();

    /**
     * Provides a hook to customize the {@link sap.fe.navigation.SelectionVariant } related to the intent-based
     * navigation.
     *
     * @since 1.86.0
     */
    adaptNavigationContext(
      /**
       * SelectionVariant provided by SAP Fiori elements.
       */
      _oSelectionVariant: SelectionVariant,
      /**
       * Object containing intent-based navigation-related info
       */
      _oNavigationInfo: {
        /**
         * Action related to the intent
         */
        action: string;
        /**
         * Semantic object related to the intent
         */
        semanticObject: string;
      }
    ): void;
    /**
     * Navigates to an intent defined by an outbound definition in the manifest.
     *
     * @since 1.86.0
     */
    navigateOutbound(
      /**
       * Identifier to locate the outbound definition in the manifest.
       * This provides the semantic object and action for the intent-based navigation.
       * Additionally, the outbound definition can be used to provide parameters for intent-based navigation.
       * See {@link topic :be0cf40f61184b358b5faedaec98b2da Descriptor for Applications, Components, and Libraries }
       * for more information.
       */
      sOutbound: string,
      /**
       * Optional map containing key/value pairs to be passed to the intent.
       * If mNavigationParameters are provided, the parameters provided in the outbound definition of the manifest
       * are ignored.
       */
      mNavigationParameters: object
    ): void;
  }
}

declare module "sap/fe/core/controllerextensions/MessageHandler" {
  import ControllerExtension from "sap/ui/core/mvc/ControllerExtension";

  /**
   * A controller extension offering message handling.
   *
   * @since 1.90.0
   * @experimental (since 1.90.0)
   */
  export default class MessageHandler extends ControllerExtension {
    constructor();

    /**
     * Shows a message dialog with transition messages if there are any.
     * The message dialog is shown as a modal dialog. Once the user confirms the dialog, all transition messages
     * are removed from the message model. If there is more than one message, a list of messages is shown. The
     * user
     * can filter on message types and can display details as well as the long text. If there is one message,
     * the dialog immediately shows the details of the message. If there is just one success message, a message
     * toast is shown instead.
     *
     * @since 1.90.0
     * @experimental (since 1.90.0)
     *
     * @returns A promise that is resolved once the user closes the dialog. If there are no messages
     * to be shown, the promise is resolved immediately
     */
    showMessageDialog(): Promise<void>;
  }
}

declare module "sap/fe/core/controllerextensions/Paginator" {
  import ControllerExtension from "sap/ui/core/mvc/ControllerExtension";

  import ODataListBinding from "sap/ui/model/odata/v4/ODataListBinding";

  import Context from "sap/ui/model/odata/v4/Context";

  /**
   * Controller extension providing hooks for the navigation using paginators
   *
   * @since 1.94.0
   */
  export default class Paginator extends ControllerExtension {
    constructor();

    /**
     * Initiates the paginator control.
     *
     * @since 1.94.0
     */
    initialize(
      /**
       * ODataListBinding object
       */
      oBinding: any | ODataListBinding,
      /**
       * Current context where the navigation is initiated
       */
      oContext?: Context
    ): void;
    /**
     * Returns the updated context after the paginator operation.
     *
     * @since 1.94.0
     */
    onContextUpdate(
      /**
       * Final context returned after the paginator action
       */
      oContext: Context
    ): void;
  }
}

declare module "sap/fe/core/controllerextensions/Routing" {
  import ControllerExtension from "sap/ui/core/mvc/ControllerExtension";

  import Context from "sap/ui/model/odata/v4/Context";

  /**
   * A controller extension offering hooks into the routing flow of the application
   *
   * @since 1.86.0
   */
  export default class Routing extends ControllerExtension {
    constructor();

    /**
     * Allows navigation to a specific context.
     *
     * @since 1.90.0
     */
    navigate(
      /**
       * Object containing the context to be navigated to
       */
      oContext: Context,
      /**
       * Object containing the parameters for the navigation
       */
      parameters?: {
        /**
         * By default, the internal algorithm decides whether the navigation preserves the previous entry. PreserveHistory
         * allows you to override this behavior.
         */
        preserveHistory: boolean;
      }
    ): void;
    /**
     * Navigate to another target.
     *
     *
     * @returns Promise that is resolved when the navigation is finalized
     */
    navigateToRoute(
      /**
       * Name of the target route
       */
      sTargetRouteName: string,
      /**
       * Parameters to be used with route to create the target hash
       */
      oParameters?: object
    ): Promise<boolean>;
    /**
     * This function is used to intercept the routing event after binding a page.
     * If it is declared as an extension, it allows you to intercept and change the normal flow of binding.
     * This function is not called directly, but overridden separately by consuming controllers.
     * The override execution is: {@link sap.ui.core.mvc.OverrideExecution.After }.
     *
     *
     * @since 1.90.0
     */
    onAfterBinding(
      /**
       * Object containing the context to be navigated
       */
      oContext: object
    ): void;
    /**
     * This function is used to intercept the routing event before binding a page.
     * If it is declared as an extension, it allows you to intercept and change the normal flow of binding.
     * This function is not called directly, but overridden separately by consuming controllers.
     * The override execution is: {@link sap.ui.core.mvc.OverrideExecution.After }.
     *
     *
     * @since 1.90.0
     */
    onBeforeBinding(
      /**
       * Object containing the context for the navigation
       */
      oContext: object
    ): void;
    /**
     * This function can be used to intercept the routing event happening during the normal process of navigating
     * from one page to another (like clicking on the table row to navigate, or when pagination buttons are
     * clicked).
     * The function is NOT called during other means of external outbound navigation (like a navigation configured
     * via a link, or by using navigation buttons).
     * If declared as an extension, it allows you to intercept and change the normal navigation flow.
     * If you decide to do your own navigation processing, you can return `true` to prevent the default routing
     * behavior.
     * This function is meant to be individually overridden by consuming controllers, but not to be called directly.
     * The override execution is: {@link sap.ui.core.mvc.OverrideExecution.After }.
     *
     *
     * @since 1.86.0
     *
     * @returns `true` to prevent the default execution, false to keep the standard behavior
     */
    onBeforeNavigation(
      /**
       * Object containing row context and page context
       */
      mNavigationParameters: {
        /**
         * The currently selected context
         */
        bindingContext: Context;
      }
    ): boolean;
  }
}

declare module "sap/fe/core/controllerextensions/Share" {
  import ControllerExtension from "sap/ui/core/mvc/ControllerExtension";

  /**
   * A controller extension offering hooks into the routing flow of the application
   *
   * @since 1.86.0
   */
  export default class Share extends ControllerExtension {
    constructor();

    /**
     * Adapts the metadata used while sharing the page URL via 'Send Email', 'Share in SAP Jam', and 'Save as
     * Tile'.
     *
     * @since 1.93.0
     *
     * @returns Share Metadata or a Promise resolving the Share Metadata
     */
    adaptShareMetadata(
      /**
       * Object containing the share metadata.
       */
      oShareMetadata: {
        /**
         * Email-specific metadata.
         */
        email: {
          /**
           * Title that will be used as "email subject" in 'Send Email'. This takes precedence over oShareMetadata.title.
           */
          title: string;
          /**
           * URL that will be used specifically for 'Send Email'. This takes precedence over oShareMetadata.url.
           */
          url: string;
        };
        /**
         * SAP Jam-specific metadata.
         */
        jam: {
          /**
           * Title that will be used as 'share text' in 'Share in SAP Jam'. This takes precedence over oShareMetadata.title.
           */
          title: string;
          /**
           * URL that will be used specifically for 'Share in SAP Jam'. This takes precedence over oShareMetadata.url.
           */
          url: string;
        };
        /**
         * Save as Tile-specific metadata.
         */
        tile: {
          /**
           * Icon to be used for the tile.
           */
          icon: string;
          /**
           * Query URL of an OData service from which data for a dynamic tile is read.
           */
          queryUrl: string;
          /**
           * Subtitle to be used for the tile.
           */
          subtitle: string;
          /**
           * Title to be used for the tile. This takes precedence over oShareMetadata.title.
           */
          title: string;
          /**
           * URL that will be used specifically for 'Save as Tile'. This takes precedence over oShareMetadata.url.
           */
          url: string;
        };
        /**
         * Default title that will be used as 'email subject' in 'Send Email', 'share text' in 'Share in SAP Jam'
         * and 'title' in 'Save as Tile'
         */
        title: string;
        /**
         * Default URL that will be used via 'Send Email', 'Share in SAP Jam', and 'Save as Tile'
         */
        url: string;
      }
    ):
      | Promise</* was: sap.fe.core.controllerextensions.Share.ShareMetadata */ any>
      | /* was: sap.fe.core.controllerextensions.Share.ShareMetadata */ any;
    /**
     * Opens the share sheet.
     *
     * @since 1.93.0
     */
    openShareSheet(
      /**
       * The control to which the ActionSheet is opened.
       */
      oControl: object
    ): void;
  }
}

declare module "sap/fe/core/controllerextensions/ViewState" {
  import ControllerExtension from "sap/ui/core/mvc/ControllerExtension";

  import ManagedObject from "sap/ui/base/ManagedObject";

  import SelectionVariant from "sap/fe/navigation/SelectionVariant";

  /**
   * A controller extension offering hooks for state handling
   * If you need to maintain a specific state for your application, you can use the controller extension.
   *
   *
   * @since 1.85.0
   */
  export default class ViewState extends ControllerExtension {
    constructor();

    /**
     * This function should add all controls relevant for refreshing to the provided control array.
     * This function is meant to be individually overridden by consuming controllers, but not to be called directly.
     * The override execution is: {@link sap.ui.core.mvc.OverrideExecution.After }.
     *
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    adaptBindingRefreshControls(
      /**
       * The collected controls
       */
      aCollectedControls: ManagedObject[]
    ): void;
    /**
     * Customize the `refreshBinding` function for a certain control.
     * This function is meant to be individually overridden by consuming controllers, but not to be called directly.
     * The override execution is: {@link sap.ui.core.mvc.OverrideExecution.After }.
     *
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    adaptBindingRefreshHandler(
      /**
       * The control for which the refresh handler is adapted.
       */
      oControl: ManagedObject,
      /**
       * A plain object which can have one function: `refreshBinding`
       */
      oControlHandler: any[]
    ): void;
    /**
     * Customize the `retrieve` and `apply` functions for a certain control.
     * This function is meant to be individually overridden by consuming controllers, but not to be called directly.
     * The override execution is: {@link sap.ui.core.mvc.OverrideExecution.After }.
     *
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    adaptControlStateHandler(
      /**
       * The control to get state handler for
       */
      oControl: ManagedObject,
      /**
       * A list of plain objects with two functions: `retrieve` and `apply`
       */
      aControlHandler: object[]
    ): void;
    /**
     * This function should add all controls for given view that should be considered for the state handling
     * to the provided control array.
     * This function is meant to be individually overridden by consuming controllers, but not to be called directly.
     * The override execution is: {@link sap.ui.core.mvc.OverrideExecution.After }.
     *
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    adaptStateControls(
      /**
       * The collected controls
       */
      aCollectedControls: ManagedObject[]
    ): void;
    /**
     * Applying additional, not control related, states - is called only if navigation type is iAppState.
     * This function is meant to be individually overridden by consuming controllers, but not to be called directly.
     * The override execution is: {@link sap.ui.core.mvc.OverrideExecution.After }.
     *
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    applyAdditionalStates(
      /**
       * The current view state
       */
      oViewState: object,
      /**
       * Extensible array of promises to be resolved before continuing
       */
      aPromises: Promise<any>
    ): void;
    /**
     * Defines whether the view state should only be applied once initially.
     * This function is meant to be individually overridden by consuming controllers, but not to be called directly.
     * The override execution is: {@link sap.ui.core.mvc.OverrideExecution.Instead }.
     * Important:
     * You should only override this method for custom pages and not for the standard ListReportPage and ObjectPage!
     *
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns If `true`, only the initial view state is applied once,
     * else any new view state is also applied on follow-up calls (default)
     */
    applyInitialStateOnly(): boolean;
    /**
     * Apply navigation parameters is not called if the navigation type is iAppState
     * This function is meant to be individually overridden by consuming controllers, but not to be called directly.
     * The override execution is: {@link sap.ui.core.mvc.OverrideExecution.After }.
     *
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    applyNavigationParameters(
      /**
       * The current navigation parameter
       */
      oNavParameter: {
        /**
         * The actual navigation type
         */
        navigationType: any;
        /**
         * Defines whether the standard variant must be used in variant management
         */
        requiresStandardVariant?: boolean | undefined;
        /**
         * The selectionVariant from the navigation
         */
        selectionVariant?: object | undefined;
        /**
         * The selectionVariant defaults from the navigation
         */
        selectionVariantDefaults?: object | undefined;
      },
      /**
       * Extensible array of promises to be resolved before continuing
       */
      aPromises: Promise<any>
    ): void;
    /**
     * Applies the given view state to this extensions view.
     *
     *
     * @returns Promise for async state handling
     */
    applyViewState(
      /**
       * The view state to apply (can be undefined)
       */
      oViewState: Record<string, unknown> | undefined,
      /**
       * The current navigation parameter
       */
      oNavParameter: NavigationParameter,
      /**
       * Boolean which determines to skip the key user shine through
       */
      skipMerge?: boolean
    ): Promise<void>;
    /**
     * Hook to react when state for given view was applied.
     * This function is meant to be individually overridden by consuming controllers, but not to be called directly.
     * The override execution is: {@link sap.ui.core.mvc.OverrideExecution.After }.
     *
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    onAfterStateApplied(
      /**
       * Extensible array of promises to be resolved before continuing
       */
      aPromises: Promise<any>
    ): void;
    /**
     * Hook to react before a state for given view is applied.
     * This function is meant to be individually overridden by consuming controllers, but not to be called directly.
     * The override execution is: {@link sap.ui.core.mvc.OverrideExecution.After }.
     *
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    onBeforeStateApplied(
      /**
       * Extensible array of promises to be resolved before continuing
       */
      aPromises: Promise<any>,
      /**
       * Navigation type responsible for the applying the state
       */
      navigationType?: string
    ): void;
    /**
     * Called when the application is restored due to keep-alive mode.
     */
    onRestore(): void;
    /**
     * Called when the application is suspended due to keep-alive mode.
     */
    onSuspend(): void;
    /**
     * Extend the map of additional states (not control bound) to be added to the current view state of the
     * given view.
     * This function is meant to be individually overridden by consuming controllers, but not to be called directly.
     * The override execution is: {@link sap.ui.core.mvc.OverrideExecution.After }.
     *
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    retrieveAdditionalStates(
      /**
       * The additional state
       */
      mAdditionalStates: object
    ): void;
    /**
     * Retrieve the view state of this extensions view.
     * When this function is called more than once before finishing, all but the final response will resolve
     * to `undefined`.
     *
     *
     * @returns A promise resolving the view state
     */
    retrieveViewState(): Promise<object | undefined>;
  }
  /**
   * Definition of a custom action to be used inside the table toolbar
   */
  export type NavigationParameter = {
    /**
     * The actual navigation type.
     */
    navigationType: string;
    /**
     * Defines whether the standard variant must be used in variant management
     */
    requiresStandardVariant: boolean;
    /**
     * The selectionVariant from the navigation.
     */
    selectionVariant: SelectionVariant;
    /**
     * The selectionVariant defaults from the navigation
     */
    selectionVariantDefaults: SelectionVariant;
  };
}

declare module "sap/fe/core/fpm/Component" {
  /**
   * Component that can be used as a wrapper component for custom pages.
   * The component can be used in case you want to use SAP Fiori elements Building Blocks or XML template
   * constructions. You can either extend the component and set the viewName and contextPath within your code
   * or you can use it to wrap your custom XML view directly the manifest when you define your custom page
   * under sapui5/routing/targets:
   *
   * ```javascript
   *
   * "myCustomPage": {
   * "type": "Component",
   * "id": "myCustomPage",
   * "name": "sap.fe.core.fpm",
   * "title": "My Custom Page",
   * "options": {
   * 	"settings": {
   * 		"viewName": "myNamespace.myView",
   * 		"contextPath": "/MyEntitySet"
   * 		}
   * 	}
   * }
   * ```
   *
   *
   *
   * @since 1.92.0
   * @experimental (since 1.92.0)
   */
  export default class Component
    /* was: sap.fe.core.TemplateComponent */ extends Object {
    constructor();
  }
}

declare module "sap/fe/core/rootView/Fcl.controller" {
  /**
   * Base controller class for your own root view with an sap.f.FlexibleColumnLayout control.
   * By using or extending this controller, you can use your own root view with the sap.fe.core.AppComponent
   * and
   * you can make use of SAP Fiori elements pages and SAP Fiori elements building blocks.
   *
   *
   * @since 1.110.0
   */
  export default class Fcl
    /* was: sap.fe.core.rootView.RootViewBaseController */ extends Object {
    constructor();

    /**
     * Method that creates a new Page to display the IllustratedMessage containing the current error.
     *
     *
     * @returns A promise that creates a Page to display the error
     */
    displayErrorPage(): Promise<boolean>;
  }
}

declare module "sap/fe/core/rootView/NavContainer.controller" {
  /**
   * Base controller class for your own root view with a sap.m.NavContainer control.
   * By using or extending this controller you can use your own root view with the sap.fe.core.AppComponent
   * and
   * you can make use of SAP Fiori elements pages and SAP Fiori elements building blocks.
   *
   *
   * @since 1.108.0
   */
  export default class NavContainer
    /* was: sap.fe.core.rootView.RootViewBaseController */ extends Object {
    constructor();

    /**
     * Method that creates a new Page to display the IllustratedMessage containing the current error.
     *
     *
     * @returns A promise that creates a Page to display the error
     */
    displayErrorPage(): Promise<boolean>;
  }
}

declare namespace sap {
  interface IUI5DefineDependencyNames {
    "sap/fe/core/AppComponent": undefined;

    "sap/fe/core/BaseController": undefined;

    "sap/fe/core/controllerextensions/BaseControllerExtension": undefined;

    "sap/fe/core/controllerextensions/EditFlow": undefined;

    "sap/fe/core/controllerextensions/IntentBasedNavigation": undefined;

    "sap/fe/core/controllerextensions/MessageHandler": undefined;

    "sap/fe/core/controllerextensions/Paginator": undefined;

    "sap/fe/core/controllerextensions/Routing": undefined;

    "sap/fe/core/controllerextensions/Share": undefined;

    "sap/fe/core/controllerextensions/ViewState": undefined;

    "sap/fe/core/ExtensionAPI": undefined;

    "sap/fe/core/fpm/Component": undefined;

    "sap/fe/core/library": undefined;

    "sap/fe/core/PageController": undefined;

    "sap/fe/core/rootView/Fcl.controller": undefined;

    "sap/fe/core/rootView/NavContainer.controller": undefined;
  }
}
