import AbstractGenerator from "./AbstractGenerator.js";
export default class ViewGenerator extends AbstractGenerator {
    writeRootControl(controlInfo) {
        controlInfo.properties.forEach((attribute) => {
            if (attribute.name === "controllerName") {
                // Outer nodes are visited last, so the controllerName is only known after
                // all controls have been visited. Only then the collected mappings can be added.
                this._controllerByIdInfo.addMappings(attribute.value, this._idToModule);
            }
        });
        this._body.write(`export default `);
        this.writeControl(controlInfo, true);
    }
}
//# sourceMappingURL=ViewGenerator.js.map