import ts from "typescript";
import { ProbingRequireExpression, RequireExpression } from "./parseRequire.js";
export interface RequireTransformationAsync {
    imports: ts.ImportDeclaration[];
    callback?: ts.CallExpression;
    errback?: ts.FunctionDeclaration;
}
export interface RequireTransformationSync {
    import: ts.ImportDeclaration;
    requireStatement: ts.Identifier | ts.AsExpression;
}
export declare function transformAsyncRequireCall(node: ts.CallExpression, requireExpression: RequireExpression, nodeFactory: ts.NodeFactory): RequireTransformationAsync;
export declare function transformSyncRequireCall(node: ts.CallExpression, requireExpression: ProbingRequireExpression, nodeFactory: ts.NodeFactory): RequireTransformationSync;
