import ts from "typescript";
export declare class UnsafeNodeRemoval extends Error {
    constructor(message: string);
}
/**
 * Marks a given node for removal. The node will be removed during a later step in the the transformation process.
 *
 * If the node's parent would become completely empty after removing the node, the parent is also marked for removal.
 * If the node's parent can't exist without the to-be-removed node, the node won't be removed.
 *
 * This is checked recursively for all parents
 */
export default function (node: ts.Node): void;
