import ts from "typescript";
export interface ModuleDeclaration {
    moduleName?: ts.StringLiteral | ts.NoSubstitutionTemplateLiteral;
    dependencies?: ts.ArrayLiteralExpression;
    factory: DefineCallArgument;
    export?: ts.BooleanLiteral;
}
/**
 * For a given array of arguments, try to match them to the parameters of the sap.ui.define and sap.ui.predefine
 * signatures
 */
export default function parseModuleDeclaration(args: ts.CallExpression["arguments"], checker: ts.TypeChecker): ModuleDeclaration;
export type DefineCallArgument = ts.StringLiteral | ts.NoSubstitutionTemplateLiteral | ts.NumericLiteral | ts.ArrayLiteralExpression | ts.BooleanLiteral | ts.PropertyAccessExpression | ts.ObjectLiteralExpression | ts.ArrowFunction | ts.FunctionExpression | ts.FunctionDeclaration | ts.ClassDeclaration;
export declare function _matchArgumentsToParameters(args: DefineCallArgument[]): ModuleDeclaration;
