import ts from "typescript";
import LinterContext, { ResourcePath } from "../LinterContext.js";
import type { ApiExtract } from "../../utils/ApiExtract.js";
interface DeprecationInfo {
    symbol: ts.Symbol;
    messageDetails: string;
}
export default class SourceFileLinter {
    #private;
    private context;
    private resourcePath;
    private sourceFile;
    private sourceMaps;
    private program;
    private checker;
    private reportCoverage;
    private messageDetails;
    private apiExtract;
    private manifestContent?;
    constructor(context: LinterContext, resourcePath: ResourcePath, sourceFile: ts.SourceFile, sourceMaps: Map<string, string> | undefined, program: ts.Program, checker: ts.TypeChecker, reportCoverage: boolean | undefined, messageDetails: boolean | undefined, apiExtract: ApiExtract, manifestContent?: string | undefined);
    lint(): Promise<void>;
    visitNode(node: ts.Node): void;
    isUi5ClassDeclaration(node: ts.Node, baseClassModule: string | string[]): node is ts.ClassDeclaration;
    analyzeControlRendererDeclaration(node: ts.ClassDeclaration): void;
    analyzeControlRendererInternals(node: ts.Node): void;
    analyzeIconCallInRenderMethod(node: ts.Node): void;
    analyzeControlRerenderMethod(node: ts.ClassDeclaration): void;
    analyzeMetadataProperty(type: string, node: ts.PropertyAssignment): void;
    analyzeIdentifier(node: ts.Identifier): void;
    analyzeImportSpecifier(node: ts.ImportSpecifier): void;
    analyzeObjectBindingPattern(node: ts.ObjectBindingPattern): void;
    analyzeObjectLiteralExpression(node: ts.ObjectLiteralExpression): void;
    analyzeNewExpression(node: ts.NewExpression): void;
    extractNamespace(node: ts.PropertyAccessExpression | ts.ElementAccessExpression): string;
    getDeprecationText(deprecatedTag: ts.JSDocTagInfo): string;
    getDeprecationInfo(symbol: ts.Symbol | undefined): DeprecationInfo | null;
    analyzeCallExpression(node: ts.CallExpression): void;
    getSymbolModuleDeclaration(symbol: ts.Symbol): ts.ModuleDeclaration | undefined;
    getDeprecationInfoForAccess(node: ts.AccessExpression): DeprecationInfo | null;
    analyzePropertyAccessExpressionForDeprecation(node: ts.AccessExpression): boolean;
    handleCallExpressionUnknownType(nodeType: ts.Type, node: ts.CallExpression): void;
    isGlobalThis(nodeType: string): boolean;
    analyzeExportedValuesByLib(node: ts.PropertyAccessExpression | ts.ElementAccessExpression): void;
    analyzePropertyAccessExpression(node: ts.AccessExpression | ts.CallExpression): void;
    isAllowedPropertyAccess(node: ts.PropertyAccessExpression | ts.ElementAccessExpression): boolean;
    analyzeImportDeclaration(importDeclarationNode: ts.ImportDeclaration): void;
    isSymbolOfUi5Type(symbol: ts.Symbol): boolean;
    isSymbolOfUi5OrThirdPartyType(symbol: ts.Symbol): boolean;
    isSymbolOfJquerySapType(symbol: ts.Symbol): boolean;
    isSymbolOfPseudoModuleType(symbol: ts.Symbol): boolean;
    checkSymbolDeclarationSourceFile(symbol: ts.Symbol, checkFunction: (sourceFile: ts.SourceFile) => boolean): boolean;
    analyzeTestsuiteThemeProperty(node: ts.PropertyAssignment): void;
}
export {};
