import { Tag as SaxTag, Text as SaxText } from "sax-wasm";
export default class HtmlReporter {
    #resourcePath;
    #context;
    constructor(resourcePath, context) {
        this.#resourcePath = resourcePath;
        this.#context = context;
    }
    addMessage(id, argsOrNode, node) {
        if (!argsOrNode) {
            throw new Error("Invalid arguments: Missing second argument");
        }
        let args;
        if (argsOrNode instanceof SaxTag) {
            node = argsOrNode;
            args = null;
        }
        else if (argsOrNode instanceof SaxText) {
            node = argsOrNode;
            args = null;
        }
        else if (!node) {
            throw new Error("Invalid arguments: Missing 'node'");
        }
        else {
            args = argsOrNode;
        }
        let startPos;
        if (node instanceof SaxTag) {
            startPos = node.openStart;
        }
        else {
            startPos = node.start;
        }
        this.#context.addLintingMessage(this.#resourcePath, id, args, {
            line: startPos.line + 1,
            column: startPos.character + 1,
        });
    }
    addCoverageInfo({ node, message, category }) {
        let line = 0, column = 0, endLine = 0, endColumn = 0;
        if (node instanceof SaxTag) {
            ({ line, character: column } = node.openStart);
            ({ line: endLine, character: endColumn } = node.closeEnd);
        }
        this.#context.addCoverageInfo(this.#resourcePath, {
            category,
            // One-based to be aligned with most IDEs
            line: line + 1,
            column: column + 1,
            endLine: endLine + 1,
            endColumn: endColumn + 1,
            message,
        });
    }
}
//# sourceMappingURL=HtmlReporter.js.map