"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.nodesEquivalent = void 0;
const t = __importStar(require("@babel/types"));
const NodeTypes_1 = require("./NodeTypes");
/**
 * Determines whether two `@babel/types` nodes are equivalent.
 */
function nodesEquivalent(a, b) {
    if (a === b) {
        return true;
    }
    if (a.type !== b.type) {
        return false;
    }
    const fields = NodeTypes_1.NODE_FIELDS[a.type];
    const aProps = a;
    const bProps = b;
    for (const [k, field] of Object.entries(fields)) {
        const key = k;
        if (field.optional && aProps[key] == null && bProps[key] == null) {
            continue;
        }
        const aVal = aProps[key];
        const bVal = bProps[key];
        if (aVal === bVal) {
            continue;
        }
        if (aVal == null || bVal == null) {
            return false;
        }
        if (Array.isArray(aVal) && Array.isArray(bVal)) {
            if (aVal.length !== bVal.length) {
                return false;
            }
            for (let i = 0; i < aVal.length; i++) {
                if (!nodesEquivalent(aVal[i], bVal[i])) {
                    return false;
                }
            }
            continue;
        }
        if (t.isNode(aVal) && t.isNode(bVal)) {
            if (!nodesEquivalent(aVal, bVal)) {
                return false;
            }
            continue;
        }
        return false;
    }
    return true;
}
exports.nodesEquivalent = nodesEquivalent;
//# sourceMappingURL=nodesEquivalent.js.map