import { Matcher } from './Matcher';
export declare class SliceMatcher<T> extends Matcher<T> {
    readonly min: number;
    readonly max: number;
    readonly matcher: Matcher<T>;
    constructor(min: number, max: number, matcher: Matcher<T>);
    matchValue(value: unknown, keys: ReadonlyArray<PropertyKey>): value is T;
}
/**
 * Match zero or more elements. For use with `anyList`.
 *
 * @example
 *
 * ```ts
 * // matches `['foo', 1]` and `['foo', 'bar', 2]` and `['foo', 'bar', 'baz', 3]` but not `['foo']` or `['foo', 'bar']`
 * m.anyList([m.anyString(), m.zeroOrMore(), m.anyNumber()])
 * ```
 */
export declare function zeroOrMore<T>(matcher?: Matcher<T>): SliceMatcher<T>;
/**
 * Match one or more elements. For use with `anyList`.
 *
 * @example
 *
 * ```ts
 * // matches `['foo']` and `['foo', 'bar']` but not `[]`
 * m.anyList([m.oneOrMore()])
 * ```
 */
export declare function oneOrMore<T>(matcher?: Matcher<T>): SliceMatcher<T>;
/**
 * Options for {@link slice}.
 */
export interface SliceOptions<T> {
    min?: number;
    max?: number;
    matcher?: Matcher<T>;
}
/**
 * Match a slice of an array. For use with `anyList`.
 *
 * @example
 *
 * ```ts
 * // matches `['foo', 'bar', 'baz']` but not `['foo']` or `['foo', 'bar', 'baz', 'qux']`
 * m.anyList([m.anyString(), m.slice({ min: 1, max: 2 })])
 * ```
 */
export declare function slice<T>({ min, max, matcher, }: SliceOptions<T>): SliceMatcher<T>;
/**
 * Match a slice of an array of the given length. For use with `anyList`.
 *
 * @example
 *
 * ```ts
 * // matches `['foo', 'bar', 'baz']` but not `['foo']` or `['foo', 'bar', 'baz', 'qux']`
 * m.anyList([m.anyString(), m.slice(2)])
 * ```
 */
export declare function slice<T>(length: number, matcher?: Matcher<T>): SliceMatcher<T>;
/**
 * @deprecated Use `slice` instead.
 */
export declare function spacer(min?: number, max?: number): SliceMatcher<unknown>;
