"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.or = exports.OrMatcher = void 0;
const Matcher_1 = require("./Matcher");
class OrMatcher extends Matcher_1.Matcher {
    constructor(...matchersOrValues) {
        super();
        this.matchersOrValues = matchersOrValues;
    }
    matchValue(value, keys) {
        for (const matcherOrValue of this.matchersOrValues) {
            if (matcherOrValue instanceof Matcher_1.Matcher) {
                if (matcherOrValue.matchValue(value, keys)) {
                    return true;
                }
            }
            else if (matcherOrValue === value) {
                return true;
            }
        }
        return false;
    }
}
exports.OrMatcher = OrMatcher;
function or(...matchersOrValues) {
    return new OrMatcher(...matchersOrValues);
}
exports.or = or;
//# sourceMappingURL=or.js.map