"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.function = exports.Function = exports.FunctionMatcher = void 0;
const t = __importStar(require("@babel/types"));
const Matcher_1 = require("./Matcher");
const tupleOf_1 = require("./tupleOf");
class FunctionMatcher extends Matcher_1.Matcher {
    constructor(params, body) {
        super();
        this.params = params;
        this.body = body;
    }
    matchValue(value, keys) {
        if (!t.isNode(value) || !t.isFunction(value)) {
            return false;
        }
        if (this.params) {
            if (Array.isArray(this.params)) {
                if (!(0, tupleOf_1.tupleOf)(...this.params).matchValue(value.params, [...keys, 'params'])) {
                    return false;
                }
            }
            else if (!this.params.matchValue(value.params, [...keys, 'params'])) {
                return false;
            }
        }
        if (this.body && !this.body.matchValue(value.body, [...keys, 'body'])) {
            return false;
        }
        return true;
    }
}
exports.FunctionMatcher = FunctionMatcher;
function Function(params, body) {
    return new FunctionMatcher(params, body);
}
exports.Function = Function;
exports.function = Function;
//# sourceMappingURL=function.js.map