import * as t from '@babel/types';
import { Matcher } from './Matcher';
import { CapturedMatcher } from './capture';
/**
 * Matches and captures using another matcher by recursively checking all
 * descendants of a given node. The matched descendant is captured as the
 * current value of this capturing matcher.
 */
export declare class ContainerOfMatcher<C extends t.Node, M extends t.Node = C> extends CapturedMatcher<C, M> {
    private readonly containedMatcher;
    constructor(containedMatcher: Matcher<C>);
    matchValue(value: unknown, keys: ReadonlyArray<PropertyKey>): value is M;
}
export declare function containerOf<C extends t.Node, M extends t.Node = C>(containedMatcher: Matcher<C>): ContainerOfMatcher<C, M>;
