"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PackageResolver = void 0;
const resolve_1 = require("resolve");
/**
 * Resolves node modules by name relative to the working directory.
 *
 * For example, if used in a project that includes `myplugin` in its
 * `node_modules`, this class will resolve to the main file of `myplugin`.
 */
class PackageResolver {
    canResolve(source) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                yield this.resolve(source);
                return true;
            }
            catch (_a) {
                return false;
            }
        });
    }
    resolve(source) {
        return __awaiter(this, void 0, void 0, function* () {
            return (0, resolve_1.sync)(source, { basedir: process.cwd() });
        });
    }
}
exports.PackageResolver = PackageResolver;
//# sourceMappingURL=PackageResolver.js.map