"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TransformableExtensions = exports.RequireableExtensions = exports.PluginExtensions = exports.JavaScriptExtensions = exports.TypeScriptExtensions = void 0;
function union(...sets) {
    return new Set(sets.reduce((result, set) => [...result, ...set], []));
}
exports.TypeScriptExtensions = new Set([
    '.ts',
    '.tsx',
    '.mts',
    '.mtsx',
    '.cts',
    '.ctsx',
]);
exports.JavaScriptExtensions = new Set([
    '.js',
    '.jsx',
    '.mjs',
    '.mjsx',
    '.cjs',
    '.cjsx',
    '.es',
    '.es6',
]);
exports.PluginExtensions = union(exports.TypeScriptExtensions, exports.JavaScriptExtensions);
exports.RequireableExtensions = union(exports.TypeScriptExtensions, exports.JavaScriptExtensions);
exports.TransformableExtensions = union(exports.TypeScriptExtensions, exports.JavaScriptExtensions);
//# sourceMappingURL=extensions.js.map