"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PluginLoader = void 0;
class PluginLoader {
    constructor(resolvers) {
        this.resolvers = resolvers;
    }
    load(source) {
        return __awaiter(this, void 0, void 0, function* () {
            for (const resolver of this.resolvers) {
                if (yield resolver.canResolve(source)) {
                    const resolvedPath = yield resolver.resolve(source);
                    return require(resolvedPath);
                }
            }
            throw new Error(`unable to resolve a plugin from source: ${source}`);
        });
    }
}
exports.PluginLoader = PluginLoader;
//# sourceMappingURL=PluginLoader.js.map