"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.InlineTransformer = void 0;
const core_1 = require("@codemod/core");
class InlineTransformer {
    constructor(plugins, parserPlugins = []) {
        this.plugins = plugins;
        this.parserPlugins = parserPlugins;
    }
    transform(filepath, content) {
        return __awaiter(this, void 0, void 0, function* () {
            const options = {
                filename: filepath,
                babelrc: false,
                configFile: false,
                plugins: [...this.plugins],
                parserOpts: {
                    plugins: [...this.parserPlugins],
                },
            };
            const result = (0, core_1.transform)(content, options);
            if (!result) {
                throw new Error(`[${filepath}] babel transform returned null`);
            }
            return result.code;
        });
    }
}
exports.InlineTransformer = InlineTransformer;
//# sourceMappingURL=InlineTransformer.js.map